"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const __1 = require("../../..");
const helper_1 = require("../../../../test/helper");
const data_source_1 = require("../../../../test/helper/data-source");
const constructs_1 = require("constructs");
describe("#synthScope", () => {
    test("basic example", () => {
        expect(__1.Testing.synthScope((stack) => {
            new data_source_1.TestDataSource(stack, "test-data-source", {
                name: "foo",
            });
            new helper_1.TestResource(stack, "test-resource", {
                name: "bar",
            });
        })).toMatchInlineSnapshot(`
      "{
        "data": {
          "test_data_source": {
            "test-data-source": {
              "name": "foo"
            }
          }
        },
        "resource": {
          "test_resource": {
            "test-resource": {
              "name": "bar"
            }
          }
        }
      }"
    `);
    });
    test("using resource", () => {
        class MyResource extends constructs_1.Construct {
            constructor(scope, id) {
                super(scope, id);
                this.resource = new helper_1.TestResource(this, "test-resource", {
                    name: "bar",
                });
            }
        }
        expect(__1.Testing.synthScope((stack) => {
            const res = new MyResource(stack, "my-resource");
            new helper_1.TestResource(stack, "resource", {
                name: res.resource.stringValue,
            });
        })).toMatchInlineSnapshot(`
      "{
        "resource": {
          "test_resource": {
            "my-resource_test-resource_4F34504B": {
              "name": "bar"
            },
            "resource": {
              "name": "\${test_resource.my-resource_test-resource_4F34504B.string_value}"
            }
          }
        }
      }"
    `);
    });
});
//# sourceMappingURL=data:application/json;base64,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