"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformVariable = exports.VariableType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const tokens_1 = require("./tokens");
const tfExpression_1 = require("./tfExpression");
// eslint-disable-next-line jsdoc/require-jsdoc
class VariableType {
    static list(type) {
        return `list(${type})`;
    }
    static map(type) {
        return `map(${type})`;
    }
    static set(type) {
        return `set(${type})`;
    }
    static tuple(...elements) {
        return `tuple(${elements.join(", ")})`;
    }
    static object(attributes) {
        return `object({${Object.keys(attributes)
            .map((k) => k + "=" + attributes[k])
            .join(", ")}})`;
    }
}
exports.VariableType = VariableType;
_a = JSII_RTTI_SYMBOL_1;
VariableType[_a] = { fqn: "cdktf.VariableType", version: "0.21.0" };
VariableType.STRING = "string";
VariableType.NUMBER = "number";
VariableType.BOOL = "bool";
VariableType.ANY = "any";
VariableType.LIST = "list";
VariableType.MAP = "map";
VariableType.SET = "set";
VariableType.LIST_STRING = "list(string)";
VariableType.LIST_NUMBER = "list(number)";
VariableType.LIST_BOOL = "list(bool)";
VariableType.MAP_STRING = "map(string)";
VariableType.MAP_NUMBER = "map(number)";
VariableType.MAP_BOOL = "map(bool)";
VariableType.SET_STRING = "set(string)";
VariableType.SET_NUMBER = "set(number)";
VariableType.SET_BOOL = "set(bool)";
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformVariable extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id, "var");
        this.default = config.default;
        this.description = config.description;
        this.type = config.type;
        this.sensitive = config.sensitive;
        this.nullable = config.nullable;
        this._validation = config.validation;
    }
    get stringValue() {
        return tokens_1.Token.asString(this.interpolation());
    }
    get numberValue() {
        return tokens_1.Token.asNumber(this.interpolation());
    }
    get listValue() {
        return tokens_1.Token.asList(this.interpolation());
    }
    get booleanValue() {
        return this.interpolation();
    }
    get value() {
        return tokens_1.Token.asAny(this.interpolation());
    }
    get validation() {
        return this._validation;
    }
    addValidation(validation) {
        if (!this._validation) {
            this._validation = [];
        }
        this._validation.push(validation);
    }
    interpolation() {
        return (0, tfExpression_1.ref)(`var.${this.friendlyUniqueId}`, this.cdktfStack);
    }
    synthesizeHclAttributes() {
        const attrs = {
            default: {
                value: this.default,
                type: "any",
            },
            description: {
                value: this.description,
                type: "simple",
                storageClassType: "string",
            },
            type: {
                value: this.type,
                type: "type",
            },
            sensitive: {
                value: this.sensitive,
                type: "simple",
                storageClassType: "boolean",
            },
            nullable: {
                value: this.nullable,
                type: "simple",
                storageClassType: "boolean",
            },
            validation: {
                value: this.validation?.map((validation) => ({
                    error_message: validation.errorMessage,
                    condition: validation.condition,
                })),
                isBlock: true,
                type: "list",
                storageClassType: "objectList",
            },
        };
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => !!value?.value));
    }
    synthesizeAttributes() {
        return {
            default: this.default,
            description: this.description,
            type: this.type,
            sensitive: this.sensitive,
            nullable: this.nullable,
            validation: this.validation?.map((validation) => ({
                error_message: validation.errorMessage,
                condition: validation.condition,
            })),
        };
    }
    toHclTerraform() {
        return {
            variable: {
                [this.friendlyUniqueId]: (0, util_1.deepMerge)((0, util_1.keysToSnakeCase)(this.synthesizeHclAttributes()), this.rawOverrides),
            },
        };
    }
    toTerraform() {
        return {
            variable: {
                [this.friendlyUniqueId]: (0, util_1.deepMerge)((0, util_1.keysToSnakeCase)(this.synthesizeAttributes()), this.rawOverrides),
            },
        };
    }
    /**
     * @returns a string token referencing the value of this variable
     */
    toString() {
        return this.stringValue;
    }
}
exports.TerraformVariable = TerraformVariable;
_b = JSII_RTTI_SYMBOL_1;
TerraformVariable[_b] = { fqn: "cdktf.TerraformVariable", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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