import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { TerraformProvider } from "./terraform-provider";
import { ITerraformDependable } from "./terraform-dependable";
import { IResolvable } from "./tokens/resolvable";
import { IInterpolatingParent } from "./terraform-addressable";
import { ITerraformIterator } from "./terraform-iterator";
import { Precondition, Postcondition } from "./terraform-conditions";
import { TerraformCount } from "./terraform-count";
import { SSHProvisionerConnection, WinrmProvisionerConnection } from "./terraform-provisioner";
import { FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner } from "./terraform-provisioner";
export interface ITerraformResource {
    readonly terraformResourceType: string;
    readonly fqn: string;
    readonly friendlyUniqueId: string;
    dependsOn?: string[];
    count?: number | TerraformCount;
    provider?: TerraformProvider;
    lifecycle?: TerraformResourceLifecycle;
    forEach?: ITerraformIterator;
    interpolationForAttribute(terraformAttribute: string): IResolvable;
}
export interface TerraformResourceLifecycle {
    readonly createBeforeDestroy?: boolean;
    readonly preventDestroy?: boolean;
    readonly ignoreChanges?: string[] | "all";
    readonly replaceTriggeredBy?: Array<ITerraformDependable | string>;
    readonly precondition?: Precondition[];
    readonly postcondition?: Postcondition[];
}
/**
 * prepares a lifecycle object for being rendered as JSON
 * currently this function:
 *  - converts all replaceTriggeredBy items that are ITerraformDependables to strings
 */
export declare function lifecycleToTerraform(lifecycle?: TerraformResourceLifecycle): TerraformResourceLifecycle | undefined;
export interface TerraformMetaArguments {
    readonly dependsOn?: ITerraformDependable[];
    readonly count?: number | TerraformCount;
    readonly provider?: TerraformProvider;
    readonly lifecycle?: TerraformResourceLifecycle;
    readonly forEach?: ITerraformIterator;
    readonly provisioners?: Array<FileProvisioner | LocalExecProvisioner | RemoteExecProvisioner>;
    readonly connection?: SSHProvisionerConnection | WinrmProvisionerConnection;
}
export interface TerraformProviderGeneratorMetadata {
    readonly providerName: string;
    readonly providerVersionConstraint?: string;
    readonly providerVersion?: string;
}
export interface TerraformResourceConfig extends TerraformMetaArguments {
    readonly terraformResourceType: string;
    readonly terraformGeneratorMetadata?: TerraformProviderGeneratorMetadata;
}
export interface TerraformResourceMoveByTarget {
    readonly moveTarget: string;
    readonly index?: string | number;
}
export interface TerraformResourceMoveById {
    readonly to: string;
    readonly from: string;
}
export interface TerraformResourceImport {
    readonly id: string;
    readonly provider?: TerraformProvider;
}
export declare class TerraformResource extends TerraformElement implements ITerraformResource, ITerraformDependable, IInterpolatingParent {
    readonly terraformResourceType: string;
    readonly terraformGeneratorMetadata?: TerraformProviderGeneratorMetadata;
    dependsOn?: string[];
    count?: number | TerraformCount;
    provider?: TerraformProvider;
    lifecycle?: TerraformResourceLifecycle;
    forEach?: ITerraformIterator;
    connection?: SSHProvisionerConnection | WinrmProvisionerConnection;
    provisioners?: Array<FileProvisioner | LocalExecProvisioner | RemoteExecProvisioner>;
    private _imported?;
    private _movedByTarget?;
    private _movedById?;
    private _hasMoved;
    constructor(scope: Construct, id: string, config: TerraformResourceConfig);
    static isTerraformResource(x: any): x is TerraformResource;
    hasResourceMove(): TerraformResourceMoveByTarget | TerraformResourceMoveById | undefined;
    getStringAttribute(terraformAttribute: string): string;
    getNumberAttribute(terraformAttribute: string): number;
    getListAttribute(terraformAttribute: string): string[];
    getBooleanAttribute(terraformAttribute: string): IResolvable;
    getNumberListAttribute(terraformAttribute: string): number[];
    getStringMapAttribute(terraformAttribute: string): {
        [key: string]: string;
    };
    getNumberMapAttribute(terraformAttribute: string): {
        [key: string]: number;
    };
    getBooleanMapAttribute(terraformAttribute: string): {
        [key: string]: boolean;
    };
    getAnyMapAttribute(terraformAttribute: string): {
        [key: string]: any;
    };
    get terraformMetaArguments(): {
        [name: string]: any;
    };
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform(): any;
    toHclTerraform(): any;
    toMetadata(): any;
    interpolationForAttribute(terraformAttribute: string): IResolvable;
    importFrom(id: string, provider?: TerraformProvider): void;
    private _getResourceTarget;
    private _addResourceTarget;
    private _buildMovedBlockByTarget;
    private _buildMovedBlock;
    /**
     * Moves this resource to the target resource given by moveTarget.
     * @param moveTarget The previously set user defined string set by .addMoveTarget() corresponding to the resource to move to.
     * @param index Optional The index corresponding to the key the resource is to appear in the foreach of a resource to move to
     */
    moveTo(moveTarget: string, index?: string | number): void;
    /**
     * Adds a user defined moveTarget string to this resource to be later used in .moveTo(moveTarget) to resolve the location of the move.
     * @param moveTarget The string move target that will correspond to this resource
     */
    addMoveTarget(moveTarget: string): void;
    /**
     * Moves this resource to the resource corresponding to "id"
     * @param id Full id of resource to move to, e.g. "aws_s3_bucket.example"
     */
    moveToId(id: string): void;
    /**
     * Move the resource corresponding to "id" to this resource. Note that the resource being moved from must be marked as moved using it's instance function.
     * @param id Full id of resource being moved from, e.g. "aws_s3_bucket.example"
     */
    moveFromId(id: string): void;
}
