"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformResourceTargets = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
const errors_1 = require("./errors");
/**
 *
 */
class TerraformResourceTargets {
    constructor() {
        this._resourceTargetMap = new Map();
    }
    prettyPrintEntries() {
        return [...this._resourceTargetMap.entries()].reduce((accum, curr) => accum + "\n" + `${curr[0]}: ${curr[1].friendlyUniqueId}`, "");
    }
    addResourceTarget(resource, target) {
        if (this._resourceTargetMap.has(target)) {
            throw (0, errors_1.moveTargetAlreadySet)(target, this._resourceTargetMap.get(target)?.friendlyUniqueId);
        }
        this._resourceTargetMap.set(target, resource);
    }
    getResourceByTarget(target) {
        const result = this._resourceTargetMap.get(target);
        if (!result) {
            throw (0, errors_1.moveTargetNotSet)(target, this.prettyPrintEntries());
        }
        return result;
    }
}
exports.TerraformResourceTargets = TerraformResourceTargets;
_a = JSII_RTTI_SYMBOL_1;
TerraformResourceTargets[_a] = { fqn: "cdktf.TerraformResourceTargets", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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