"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformRemoteState = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const tokens_1 = require("./tokens");
const util_1 = require("./util");
const tfExpression_1 = require("./tfExpression");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformRemoteState extends terraform_element_1.TerraformElement {
    constructor(scope, id, backend, config) {
        super(scope, id, "data.terraform_remote_state");
        this.backend = backend;
        this.config = config;
    }
    getString(output) {
        return tokens_1.Token.asString(this.interpolationForAttribute(output));
    }
    getNumber(output) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(output));
    }
    getList(output) {
        return tokens_1.Token.asList(this.interpolationForAttribute(output));
    }
    getBoolean(output) {
        return this.interpolationForAttribute(output);
    }
    get(output) {
        return this.interpolationForAttribute(output);
    }
    interpolationForAttribute(terraformAttribute) {
        return (0, tfExpression_1.ref)(`data.terraform_remote_state.${this.friendlyUniqueId}.outputs.${terraformAttribute}`, this.cdktfStack);
    }
    extractConfig() {
        const configObj = (0, util_1.keysToSnakeCase)({ ...this.config });
        delete configObj.workspace;
        delete configObj.defaults;
        return configObj;
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toHclTerraform() {
        return {
            data: {
                terraform_remote_state: {
                    [this.friendlyUniqueId]: (0, util_1.deepMerge)({
                        backend: this.backend,
                        workspace: this.config.workspace,
                        defaults: this.config.defaults,
                        config: this.extractConfig(),
                    }, this.rawOverrides),
                },
            },
        };
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        return {
            data: {
                terraform_remote_state: {
                    [this.friendlyUniqueId]: (0, util_1.deepMerge)({
                        backend: this.backend,
                        workspace: this.config.workspace,
                        defaults: this.config.defaults,
                        config: this.extractConfig(),
                    }, this.rawOverrides),
                },
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                terraform_remote_state: Object.keys(this.rawOverrides),
            },
        };
    }
}
exports.TerraformRemoteState = TerraformRemoteState;
_a = JSII_RTTI_SYMBOL_1;
TerraformRemoteState[_a] = { fqn: "cdktf.TerraformRemoteState", version: "0.21.0" };
TerraformRemoteState.tfResourceType = "terraform_remote_state";
//# sourceMappingURL=data:application/json;base64,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