"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformSelf = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const tfExpression_1 = require("./tfExpression");
const token_1 = require("./tokens/token");
const util_1 = require("./util");
/**
 * Expressions in connection blocks cannot refer to their parent resource by name.
 * References create dependencies, and referring to a resource by name within its own block would create a dependency cycle.
 * Instead, expressions can use the self object, which represents the connection's parent resource and has all of that resource's attributes.
 * For example, use self.public_ip to reference an aws_instance's public_ip attribute.
 */
class TerraformSelf {
    static getInterpolation(key) {
        return `self.${key
            .split(".")
            .map((s) => (0, util_1.snakeCase)(s))
            .join(".")}`;
    }
    /**
     * Only usable within a connection block to reference the connections parent resource.
     * Access a property on the resource like this: `getString("publicIp")`
     */
    static getString(key) {
        return token_1.Token.asString((0, tfExpression_1.ref)(TerraformSelf.getInterpolation(key)));
    }
    /**
     * Only usable within a connection block to reference the connections parent resource.
     * Access a property on the resource like this: `getNumber("hostPort")`
     */
    static getNumber(key) {
        return token_1.Token.asNumber((0, tfExpression_1.ref)(TerraformSelf.getInterpolation(key)));
    }
    /**
     * Only usable within a connection block to reference the connections parent resource.
     * Access a property on the resource like this: `getAny("hostPort")`
     */
    static getAny(key) {
        return token_1.Token.asAny((0, tfExpression_1.ref)(TerraformSelf.getInterpolation(key)));
    }
}
exports.TerraformSelf = TerraformSelf;
_a = JSII_RTTI_SYMBOL_1;
TerraformSelf[_a] = { fqn: "cdktf.TerraformSelf", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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