"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const TERRAFORM_PROVIDER_SYMBOL = Symbol.for("cdktf/TerraformProvider");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformProvider extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id);
        Object.defineProperty(this, TERRAFORM_PROVIDER_SYMBOL, { value: true });
        this.terraformResourceType = config.terraformResourceType;
        this.terraformGeneratorMetadata = config.terraformGeneratorMetadata;
        this.terraformProviderSource = config.terraformProviderSource;
    }
    static isTerraformProvider(x) {
        return (x !== null && typeof x === "object" && TERRAFORM_PROVIDER_SYMBOL in x);
    }
    get alias() {
        // This is always* being overridden currently
        return undefined;
    }
    set alias(_value) {
        // This is always* being overridden currently
    }
    get fqn() {
        return this.alias !== undefined
            ? tokens_1.Token.asString(`${this.terraformResourceType}.${this.alias}`)
            : tokens_1.Token.asString(`${this.terraformResourceType}`);
    }
    get metaAttributes() {
        return this.alias !== undefined ? { alias: this.alias } : {};
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    synthesizeHclAttributes() {
        return {};
    }
    toHclTerraform() {
        return {
            terraform: {
                required_providers: {
                    [this.terraformResourceType]: {
                        version: this.terraformGeneratorMetadata?.providerVersion ||
                            this.terraformGeneratorMetadata?.providerVersionConstraint, // fallback to previous to ease transition
                        source: this.terraformProviderSource,
                    },
                },
            },
            provider: {
                [this.terraformResourceType]: [
                    (0, util_1.deepMerge)((0, util_1.keysToSnakeCase)((0, util_1.processDynamicAttributesForHcl)(this.synthesizeHclAttributes())), this.rawOverrides, this.metaAttributes),
                ],
            },
        };
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        return {
            terraform: {
                required_providers: {
                    [this.terraformResourceType]: {
                        version: this.terraformGeneratorMetadata?.providerVersion ||
                            this.terraformGeneratorMetadata?.providerVersionConstraint, // fallback to previous to ease transition
                        source: this.terraformProviderSource,
                    },
                },
            },
            provider: {
                [this.terraformResourceType]: [
                    (0, util_1.deepMerge)((0, util_1.keysToSnakeCase)((0, util_1.processDynamicAttributes)(this.synthesizeAttributes())), this.rawOverrides, this.metaAttributes),
                ],
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [this.terraformResourceType]: Object.keys(this.rawOverrides),
            },
        };
    }
}
exports.TerraformProvider = TerraformProvider;
_a = JSII_RTTI_SYMBOL_1;
TerraformProvider[_a] = { fqn: "cdktf.TerraformProvider", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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