import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { TerraformProviderGeneratorMetadata } from "./terraform-resource";
export interface TerraformProviderConfig {
    readonly terraformResourceType: string;
    readonly terraformGeneratorMetadata?: TerraformProviderGeneratorMetadata;
    readonly terraformProviderSource?: string;
}
export declare abstract class TerraformProvider extends TerraformElement {
    readonly terraformResourceType: string;
    readonly terraformGeneratorMetadata?: TerraformProviderGeneratorMetadata;
    readonly terraformProviderSource?: string;
    constructor(scope: Construct, id: string, config: TerraformProviderConfig);
    static isTerraformProvider(x: any): x is TerraformProvider;
    get alias(): string | undefined;
    set alias(_value: string | undefined);
    get fqn(): string;
    get metaAttributes(): {
        [name: string]: any;
    };
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
    toHclTerraform(): any;
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform(): any;
    toMetadata(): any;
}
