"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformOutput = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const util_2 = require("util");
const tokens_1 = require("./tokens");
const TERRAFORM_OUTPUT_SYMBOL = Symbol.for("cdktf/TerraformOutput");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformOutput extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id);
        this.value = config.value;
        this.description = config.description;
        this.sensitive = config.sensitive;
        this.dependsOn = config.dependsOn;
        this.staticId = config.staticId || false;
        this.precondition = config.precondition;
        Object.defineProperty(this, TERRAFORM_OUTPUT_SYMBOL, { value: true });
    }
    static isTerraformOutput(x) {
        return x !== null && typeof x === "object" && TERRAFORM_OUTPUT_SYMBOL in x;
    }
    set staticId(staticId) {
        if (staticId)
            this.overrideLogicalId(this.node.id);
        else
            this.resetOverrideLogicalId();
    }
    get staticId() {
        return this.friendlyUniqueId === this.node.id;
    }
    isITerraformAddressable(object) {
        return (object &&
            typeof object === "object" &&
            !(0, util_2.isArray)(object) &&
            "fqn" in object);
    }
    synthesizeValue(arg) {
        if (tokens_1.Token.isUnresolved(arg)) {
            return arg;
        }
        if (this.isITerraformAddressable(arg)) {
            return arg.fqn;
        }
        if (Array.isArray(arg)) {
            return arg.map((innerArg) => this.synthesizeValue(innerArg));
        }
        if (typeof arg === "object") {
            return Object.keys(arg).reduce((result, key) => {
                result[key] = this.synthesizeValue(arg[key]);
                return result;
            }, {});
        }
        return arg;
    }
    synthesizeAttributes() {
        return {
            value: this.synthesizeValue(this.value),
            description: this.description,
            sensitive: this.sensitive,
            depends_on: this.dependsOn?.map((resource) => resource.fqn),
        };
    }
    synthesizeHclAttributes() {
        return Object.fromEntries(Object.entries({
            value: {
                value: this.synthesizeValue(this.value),
                type: "any",
                isBlock: false,
                storageClassType: "",
            },
            description: {
                value: this.description,
                type: "simple",
                isBlock: false,
                storageClassType: "string",
            },
            sensitive: {
                value: this.sensitive,
                type: "simple",
                isBlock: false,
                storageClassType: "bool",
            },
            depends_on: {
                value: this.dependsOn?.map((resource) => resource.fqn),
                type: "list",
                isBlock: false,
                storageClassType: "stringList",
            },
        }).filter(([, value]) => value.value !== undefined));
    }
    toHclTerraform() {
        return {
            output: {
                [this.friendlyUniqueId]: (0, util_1.deepMerge)(this.synthesizeHclAttributes(), this.rawOverrides),
            },
        };
    }
    toTerraform() {
        return {
            output: {
                [this.friendlyUniqueId]: (0, util_1.deepMerge)(this.synthesizeAttributes(), this.rawOverrides),
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                output: Object.keys(this.rawOverrides),
            },
        };
    }
}
exports.TerraformOutput = TerraformOutput;
_a = JSII_RTTI_SYMBOL_1;
TerraformOutput[_a] = { fqn: "cdktf.TerraformOutput", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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