"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Op = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
const tfExpression_1 = require("./tfExpression");
const tokens_1 = require("./tokens");
/**
 * This class contains static functions for all arithmetical and logical operators
 * in the Terraform configuration language.
 */
class Op {
    /**
     * Renders !expression
     */
    static not(expression) {
        return new tfExpression_1.OperatorExpression("!", expression);
    }
    /**
     * Renders -expression
     */
    static negate(expression) {
        return tokens_1.Token.asNumber(new tfExpression_1.OperatorExpression("-", expression));
    }
    /**
     * Renders left * right
     */
    static mul(left, right) {
        return tokens_1.Token.asNumber(new tfExpression_1.OperatorExpression("*", left, right));
    }
    /**
     * Renders left / right
     */
    static div(left, right) {
        return tokens_1.Token.asNumber(new tfExpression_1.OperatorExpression("/", left, right));
    }
    /**
     * Renders left % right
     */
    static mod(left, right) {
        return tokens_1.Token.asNumber(new tfExpression_1.OperatorExpression("%", left, right));
    }
    /**
     * Renders left + right
     */
    static add(left, right) {
        return tokens_1.Token.asNumber(new tfExpression_1.OperatorExpression("+", left, right));
    }
    /**
     * Renders left - right
     */
    static sub(left, right) {
        return tokens_1.Token.asNumber(new tfExpression_1.OperatorExpression("-", left, right));
    }
    /**
     * Renders left > right
     */
    static gt(left, right) {
        return new tfExpression_1.OperatorExpression(">", left, right);
    }
    /**
     * Renders left >= right
     */
    static gte(left, right) {
        return new tfExpression_1.OperatorExpression(">=", left, right);
    }
    /**
     * Renders left < right
     */
    static lt(left, right) {
        return new tfExpression_1.OperatorExpression("<", left, right);
    }
    /**
     * Renders left <= right
     */
    static lte(left, right) {
        return new tfExpression_1.OperatorExpression("<=", left, right);
    }
    /**
     * Renders left == right
     */
    static eq(left, right) {
        return new tfExpression_1.OperatorExpression("==", left, right);
    }
    /**
     * Renders left != right
     */
    static neq(left, right) {
        return new tfExpression_1.OperatorExpression("!=", left, right);
    }
    /**
     * Renders left && right
     */
    static and(left, right) {
        return new tfExpression_1.OperatorExpression("&&", left, right);
    }
    /**
     * Renders left || right
     */
    static or(left, right) {
        return new tfExpression_1.OperatorExpression("||", left, right);
    }
}
exports.Op = Op;
_a = JSII_RTTI_SYMBOL_1;
Op[_a] = { fqn: "cdktf.Op", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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