import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { TerraformProvider } from "./terraform-provider";
import { ITerraformDependable } from "./terraform-dependable";
import { ITerraformIterator } from "./terraform-iterator";
export interface TerraformModuleUserConfig {
    readonly providers?: (TerraformProvider | TerraformModuleProvider)[];
    readonly dependsOn?: ITerraformDependable[];
    readonly forEach?: ITerraformIterator;
    readonly skipAssetCreationFromLocalModules?: boolean;
}
export interface TerraformModuleConfig extends TerraformModuleUserConfig {
    readonly source: string;
    readonly version?: string;
}
export interface TerraformModuleProvider {
    readonly provider: TerraformProvider;
    readonly moduleAlias: string;
}
/**
 * TerraformModule can be used to reference a local terraform module or a module from the Terraform Registry.
 * It should be used if you can not use generated bindings for the module as you would get by adding the module
 * to your cdktf.json files "terraformModules" array and running cdktf get.
 *
 * This class is not creating a Terraform module to be used outside of CDKTF.
 * If you want to bundle certain resources together like you would do with a Terraform module,
 * you should use Constructs instead, see http://cdk.tf/constructs for more details.
 */
export declare abstract class TerraformModule extends TerraformElement implements ITerraformDependable {
    readonly source: string;
    readonly version?: string;
    private _providers?;
    dependsOn?: string[];
    forEach?: ITerraformIterator;
    readonly skipAssetCreationFromLocalModules?: boolean;
    constructor(scope: Construct, id: string, options: TerraformModuleConfig);
    private onSynth;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
    interpolationForOutput(moduleOutput: string): import("./tokens").IResolvable;
    getString(output: string): string;
    get providers(): (TerraformProvider | TerraformModuleProvider)[] | undefined;
    addProvider(provider: TerraformProvider | TerraformModuleProvider): void;
    toHclTerraform(): any;
    toTerraform(): any;
    toMetadata(): any;
    private validateIfProvidersHaveUniqueKeys;
}
