/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from "constructs";
/**
 * This Construct is being created as a singleton whenever the first
 * TerraformModule with a local source is created in a stack.
 *
 * When Terraform modules depend on local modules, the local modules
 * they depend on need to have the correct relative path to the module
 * in the asset. This only works if all modules are in one asset.
 *
 * (We could theoretically detect if a module uses relative path references, but this is easier)
 * @internal
 */
export declare class TerraformModuleAsset extends Construct {
    private readonly relativeAssetPath;
    private readonly asset;
    constructor(scope: Construct, id: string);
    static of(construct: Construct): TerraformModuleAsset;
    /**
     * The input source is relative to cwd, but we want the value relative
     * to the assets target, so the common path prefix
     */
    private relativeModulePath;
    getAssetPathForModule(source: string): string;
}
/**
 * Finds the lowest common path of all relaticve paths in the given array
 */
export declare function findLowestCommonPath(paths: string[]): string | undefined;
