"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformHclModule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_module_1 = require("./terraform-module");
const tokens_1 = require("./tokens");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformHclModule extends terraform_module_1.TerraformModule {
    constructor(scope, id, options) {
        super(scope, id, options);
        this._variables = options.variables;
    }
    get variables() {
        return this._variables;
    }
    set(variable, value) {
        if (!this._variables) {
            this._variables = {};
        }
        this._variables[variable] = value;
    }
    get(output) {
        return tokens_1.Token.asAny(this.interpolationForOutput(output));
    }
    getNumber(output) {
        return tokens_1.Token.asNumber(this.interpolationForOutput(output));
    }
    getBoolean(output) {
        return this.interpolationForOutput(output);
    }
    getList(output) {
        return tokens_1.Token.asList(this.interpolationForOutput(output));
    }
    synthesizeAttributes() {
        return { ...this.variables };
    }
    synthesizeHclAttributes() {
        if (!this.variables) {
            return {};
        }
        return Object.fromEntries(Object.entries(this.variables).map(([key, variable]) => {
            return [
                key,
                {
                    value: variable,
                    type: "any",
                },
            ];
        }));
    }
}
exports.TerraformHclModule = TerraformHclModule;
_a = JSII_RTTI_SYMBOL_1;
TerraformHclModule[_a] = { fqn: "cdktf.TerraformHclModule", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVycmFmb3JtLWhjbC1tb2R1bGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXJyYWZvcm0taGNsLW1vZHVsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUdBLHlEQUE0RTtBQUM1RSxxQ0FBOEM7QUFNOUMsK0NBQStDO0FBQy9DLE1BQWEsa0JBQW1CLFNBQVEsa0NBQWU7SUFHckQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxPQUFpQztRQUN6RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxPQUFPLENBQUMsQ0FBQztRQUUxQixJQUFJLENBQUMsVUFBVSxHQUFHLE9BQU8sQ0FBQyxTQUFTLENBQUM7SUFDdEMsQ0FBQztJQUVELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUVNLEdBQUcsQ0FBQyxRQUFnQixFQUFFLEtBQVU7UUFDckMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQztZQUNyQixJQUFJLENBQUMsVUFBVSxHQUFHLEVBQUUsQ0FBQztRQUN2QixDQUFDO1FBQ0QsSUFBSSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsR0FBRyxLQUFLLENBQUM7SUFDcEMsQ0FBQztJQUVNLEdBQUcsQ0FBQyxNQUFjO1FBQ3ZCLE9BQU8sY0FBSyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsc0JBQXNCLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBRU0sU0FBUyxDQUFDLE1BQWM7UUFDN0IsT0FBTyxjQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQzdELENBQUM7SUFFTSxVQUFVLENBQUMsTUFBYztRQUM5QixPQUFPLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0sT0FBTyxDQUFDLE1BQWM7UUFDM0IsT0FBTyxjQUFLLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQzNELENBQUM7SUFFUyxvQkFBb0I7UUFDNUIsT0FBTyxFQUFFLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO0lBQy9CLENBQUM7SUFFUyx1QkFBdUI7UUFDL0IsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQztZQUNwQixPQUFPLEVBQUUsQ0FBQztRQUNaLENBQUM7UUFFRCxPQUFPLE1BQU0sQ0FBQyxXQUFXLENBQ3ZCLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFNBQWdCLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxRQUFRLENBQUMsRUFBRSxFQUFFO1lBQzVELE9BQU87Z0JBQ0wsR0FBRztnQkFDSDtvQkFDRSxLQUFLLEVBQUUsUUFBUTtvQkFDZixJQUFJLEVBQUUsS0FBSztpQkFDWjthQUNGLENBQUM7UUFDSixDQUFDLENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQzs7QUF4REgsZ0RBeURDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluY1xuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1QTC0yLjBcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBUZXJyYWZvcm1Nb2R1bGVDb25maWcsIFRlcnJhZm9ybU1vZHVsZSB9IGZyb20gXCIuL3RlcnJhZm9ybS1tb2R1bGVcIjtcbmltcG9ydCB7IFRva2VuLCBJUmVzb2x2YWJsZSB9IGZyb20gXCIuL3Rva2Vuc1wiO1xuXG5leHBvcnQgaW50ZXJmYWNlIFRlcnJhZm9ybUhjbE1vZHVsZUNvbmZpZyBleHRlbmRzIFRlcnJhZm9ybU1vZHVsZUNvbmZpZyB7XG4gIHJlYWRvbmx5IHZhcmlhYmxlcz86IHsgW2tleTogc3RyaW5nXTogYW55IH07XG59XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgY2xhc3MgVGVycmFmb3JtSGNsTW9kdWxlIGV4dGVuZHMgVGVycmFmb3JtTW9kdWxlIHtcbiAgcHJpdmF0ZSBfdmFyaWFibGVzPzogeyBba2V5OiBzdHJpbmddOiBhbnkgfTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBvcHRpb25zOiBUZXJyYWZvcm1IY2xNb2R1bGVDb25maWcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIG9wdGlvbnMpO1xuXG4gICAgdGhpcy5fdmFyaWFibGVzID0gb3B0aW9ucy52YXJpYWJsZXM7XG4gIH1cblxuICBwdWJsaWMgZ2V0IHZhcmlhYmxlcygpIHtcbiAgICByZXR1cm4gdGhpcy5fdmFyaWFibGVzO1xuICB9XG5cbiAgcHVibGljIHNldCh2YXJpYWJsZTogc3RyaW5nLCB2YWx1ZTogYW55KSB7XG4gICAgaWYgKCF0aGlzLl92YXJpYWJsZXMpIHtcbiAgICAgIHRoaXMuX3ZhcmlhYmxlcyA9IHt9O1xuICAgIH1cbiAgICB0aGlzLl92YXJpYWJsZXNbdmFyaWFibGVdID0gdmFsdWU7XG4gIH1cblxuICBwdWJsaWMgZ2V0KG91dHB1dDogc3RyaW5nKTogYW55IHtcbiAgICByZXR1cm4gVG9rZW4uYXNBbnkodGhpcy5pbnRlcnBvbGF0aW9uRm9yT3V0cHV0KG91dHB1dCkpO1xuICB9XG5cbiAgcHVibGljIGdldE51bWJlcihvdXRwdXQ6IHN0cmluZyk6IG51bWJlciB7XG4gICAgcmV0dXJuIFRva2VuLmFzTnVtYmVyKHRoaXMuaW50ZXJwb2xhdGlvbkZvck91dHB1dChvdXRwdXQpKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXRCb29sZWFuKG91dHB1dDogc3RyaW5nKTogSVJlc29sdmFibGUge1xuICAgIHJldHVybiB0aGlzLmludGVycG9sYXRpb25Gb3JPdXRwdXQob3V0cHV0KTtcbiAgfVxuXG4gIHB1YmxpYyBnZXRMaXN0KG91dHB1dDogc3RyaW5nKTogc3RyaW5nW10ge1xuICAgIHJldHVybiBUb2tlbi5hc0xpc3QodGhpcy5pbnRlcnBvbGF0aW9uRm9yT3V0cHV0KG91dHB1dCkpO1xuICB9XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4geyAuLi50aGlzLnZhcmlhYmxlcyB9O1xuICB9XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVIY2xBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICBpZiAoIXRoaXMudmFyaWFibGVzKSB7XG4gICAgICByZXR1cm4ge307XG4gICAgfVxuXG4gICAgcmV0dXJuIE9iamVjdC5mcm9tRW50cmllcyhcbiAgICAgIE9iamVjdC5lbnRyaWVzKHRoaXMudmFyaWFibGVzIGFzIGFueSkubWFwKChba2V5LCB2YXJpYWJsZV0pID0+IHtcbiAgICAgICAgcmV0dXJuIFtcbiAgICAgICAgICBrZXksXG4gICAgICAgICAge1xuICAgICAgICAgICAgdmFsdWU6IHZhcmlhYmxlLFxuICAgICAgICAgICAgdHlwZTogXCJhbnlcIixcbiAgICAgICAgICB9LFxuICAgICAgICBdO1xuICAgICAgfSksXG4gICAgKTtcbiAgfVxufVxuIl19