import { Construct } from "constructs";
import { TerraformModuleConfig, TerraformModule } from "./terraform-module";
import { IResolvable } from "./tokens";
export interface TerraformHclModuleConfig extends TerraformModuleConfig {
    readonly variables?: {
        [key: string]: any;
    };
}
export declare class TerraformHclModule extends TerraformModule {
    private _variables?;
    constructor(scope: Construct, id: string, options: TerraformHclModuleConfig);
    get variables(): {
        [key: string]: any;
    } | undefined;
    set(variable: string, value: any): void;
    get(output: string): any;
    getNumber(output: string): number;
    getBoolean(output: string): IResolvable;
    getList(output: string): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
