"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Fn = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const _1 = require(".");
const helpers_1 = require("./functions/helpers");
const terraform_functions_generated_1 = require("./functions/terraform-functions.generated");
// eslint-disable-next-line jsdoc/require-jsdoc
class Fn extends terraform_functions_generated_1.FnGenerated {
    /**
     * {@link /terraform/docs/language/functions/bcrypt.html bcrypt} computes a hash of the given string using the Blowfish cipher, returning a string in [the _Modular Crypt Format_](https://passlib.readthedocs.io/en/stable/modular_crypt_format.html) usually expected in the shadow password file on many Unix systems.
     * @param {string} str
     * @param {number} [cost]
     */
    static bcrypt(str, cost) {
        // overwritten because bcrypt() only supports a single variadic parameter and not multiple
        // There is currently nothing in the schema that represents this runtime check:
        // https://github.com/hashicorp/terraform/blob/6ab3faf5f65a90ae1e5bd0625fa9e83c0b34c5e1/internal/lang/funcs/crypto.go#L115-L117
        return Fn._bcrypt(str, cost ? [cost] : []);
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/expressions/conditionals} A conditional expression uses the value of a boolean expression to select one of two values.
     * @param {Expression} condition
     * @param {Expression} trueValue
     * @param {Expression} falseValue
     */
    static conditional(condition, trueValue, falseValue) {
        return (0, _1.conditional)(condition, trueValue, falseValue);
    }
    /**
     * {@link /terraform/docs/language/functions/lookup.html lookup} retrieves the value of a single element from a map, given its key. If the given key does not exist, the given default value is returned instead.
     * @param {any} inputMap
     * @param {string} key
     * @param {any} [defaultValue]
     */
    static lookup(inputMap, key, defaultValue) {
        // overwritten because lookup() uses a variadic argument for its optional defaultValue
        if (defaultValue)
            return Fn._lookup(inputMap, key, [defaultValue]);
        return (0, helpers_1.asAny)((0, _1.propertyAccess)(inputMap, [key])); // -> renders inputMap[key] (which is recommended if no default value is given)
    }
    /**
     * returns a property access expression that accesses the property at the given path in the given inputMap.
     * For example lookupNested(x, ["a", "b", "c"]) will return a Terraform expression like x["a"]["b"]["c"]
     * @param {any} inputMap
     * @param {Array<any>} path
     */
    static lookupNested(inputMap, path) {
        return (0, helpers_1.asAny)((0, _1.propertyAccess)(inputMap, path));
    }
    /**
     * {@link /terraform/docs/language/functions/join.html join} produces a string by concatenating together all elements of a given list of strings with the given delimiter.
     * @param {string} separator
     * @param {Array<string>} list
     */
    static join(separator, list) {
        // overwritten because join() supports passing multiple lists to it e.g. join(sep, listA, listB)
        // which we can't model as JSII does not support variadic arguments
        return Fn._join(separator, [list]);
    }
    /**
     * {@link /terraform/docs/language/functions/range.html range} generates a list of numbers using a start value, a limit value, and a step value.
     * @param {number} start
     * @param {number} limit
     * @param {number} [step=1]
     */
    static range(start, limit, step = 1) {
        // overwritten because the step param in range() is optional which
        // the Terraform functions schema represents as a single variadic argument
        return Fn._range([start, limit, step]);
    }
    /**
     * Use this function to wrap a string and escape it properly for the use in Terraform
     * This is only needed in certain scenarios (e.g., if you have unescaped double quotes in the string)
     * @param {String} str
     */
    static rawString(str) {
        return _1.Token.asString((0, _1.rawString)(str));
    }
}
exports.Fn = Fn;
_a = JSII_RTTI_SYMBOL_1;
Fn[_a] = { fqn: "cdktf.Fn", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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