"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformElement = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const assert_1 = require("assert");
const constructs_1 = require("constructs");
const tokens_1 = require("./tokens");
const terraform_stack_1 = require("./terraform-stack");
const tfExpression_1 = require("./tfExpression");
const errors_1 = require("./errors");
const TERRAFORM_ELEMENT_SYMBOL = Symbol.for("cdktf/TerraformElement");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformElement extends constructs_1.Construct {
    constructor(scope, id, elementType) {
        super(scope, id);
        this.rawOverrides = {};
        Object.defineProperty(this, TERRAFORM_ELEMENT_SYMBOL, { value: true });
        this._elementType = elementType;
        if (tokens_1.Token.isUnresolved(id)) {
            throw (0, errors_1.unresolvedTokenInConstructId)(id);
        }
        this.node.addMetadata("stacktrace", "trace");
    }
    get cdktfStack() {
        return terraform_stack_1.TerraformStack.of(this);
    }
    static isTerraformElement(x) {
        return x !== null && typeof x === "object" && TERRAFORM_ELEMENT_SYMBOL in x;
    }
    toTerraform() {
        return {};
    }
    toHclTerraform() {
        return {};
    }
    toMetadata() {
        return {};
    }
    get fqn() {
        if (!this._fqnToken) {
            (0, assert_1.ok)(!!this._elementType, "Element type not set");
            this._fqnToken = tokens_1.Token.asString((0, tfExpression_1.ref)(`${this._elementType}.${this.friendlyUniqueId}`, this.cdktfStack));
        }
        return this._fqnToken;
    }
    get friendlyUniqueId() {
        if (!this._friendlyUniqueId) {
            if (this._logicalIdOverride) {
                this._friendlyUniqueId = this._logicalIdOverride;
            }
            else {
                this._friendlyUniqueId = this.cdktfStack.getLogicalId(this);
            }
        }
        return this._friendlyUniqueId;
    }
    /**
     * Overrides the auto-generated logical ID with a specific ID.
     * @param newLogicalId The new logical ID to use for this stack element.
     */
    overrideLogicalId(newLogicalId) {
        (0, assert_1.ok)(!this._fqnToken, "Logical ID may not be overridden once .fqn has been requested. Make sure to override the id before passing the construct to other constructs.");
        this._logicalIdOverride = newLogicalId;
    }
    /**
     * Resets a previously passed logical Id to use the auto-generated logical id again
     */
    resetOverrideLogicalId() {
        (0, assert_1.ok)(!this._fqnToken, "Logical ID may not be overridden once .fqn has been requested. You can only reset the override before you pass the construct to other constructs.");
        this._logicalIdOverride = undefined;
    }
    addOverride(path, value) {
        const parts = path.split(".");
        let curr = this.rawOverrides;
        while (parts.length > 1) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const key = parts.shift();
            // if we can't recurse further or the previous value is not an
            // object overwrite it with an object.
            const isObject = curr[key] != null &&
                typeof curr[key] === "object" &&
                !Array.isArray(curr[key]);
            if (!isObject) {
                curr[key] = {};
            }
            curr = curr[key];
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const lastKey = parts.shift();
        curr[lastKey] = value;
    }
    get constructNodeMetadata() {
        return {
            metadata: {
                path: this.node.path,
                uniqueId: this.friendlyUniqueId,
                stackTrace: this.node.metadata.find((e) => e.type === "stacktrace")
                    ?.trace,
            },
        };
    }
}
exports.TerraformElement = TerraformElement;
_a = JSII_RTTI_SYMBOL_1;
TerraformElement[_a] = { fqn: "cdktf.TerraformElement", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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