"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformDataSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
const terraform_element_1 = require("./terraform-element");
const terraform_resource_1 = require("./terraform-resource");
const util_1 = require("./util");
const tfExpression_1 = require("./tfExpression");
const terraform_count_1 = require("./terraform-count");
// eslint-disable-next-line @typescript-eslint/no-require-imports
const assert = require("assert");
const TERRAFORM_DATA_SOURCE_SYMBOL = Symbol.for("cdktf/TerraformDataSource");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformDataSource extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id, `data.${config.terraformResourceType}`);
        Object.defineProperty(this, TERRAFORM_DATA_SOURCE_SYMBOL, { value: true });
        this.terraformResourceType = config.terraformResourceType;
        this.terraformGeneratorMetadata = config.terraformGeneratorMetadata;
        if (Array.isArray(config.dependsOn)) {
            this.dependsOn = config.dependsOn.map((dependency) => (0, tfExpression_1.dependable)(dependency));
        }
        this.count = config.count;
        this.provider = config.provider;
        this.lifecycle = config.lifecycle;
        this.forEach = config.forEach;
    }
    static isTerraformDataSource(x) {
        return (x !== null && typeof x === "object" && TERRAFORM_DATA_SOURCE_SYMBOL in x);
    }
    getStringAttribute(terraformAttribute) {
        return tokens_1.Token.asString(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberAttribute(terraformAttribute) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(terraformAttribute));
    }
    getListAttribute(terraformAttribute) {
        return tokens_1.Token.asList(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanAttribute(terraformAttribute) {
        return this.interpolationForAttribute(terraformAttribute);
    }
    getNumberListAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberList(this.interpolationForAttribute(terraformAttribute));
    }
    getStringMapAttribute(terraformAttribute) {
        return tokens_1.Token.asStringMap(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberMapAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberMap(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanMapAttribute(terraformAttribute) {
        return tokens_1.Token.asBooleanMap(this.interpolationForAttribute(terraformAttribute));
    }
    getAnyMapAttribute(terraformAttribute) {
        return tokens_1.Token.asAnyMap(this.interpolationForAttribute(terraformAttribute));
    }
    get terraformMetaArguments() {
        assert(!this.forEach || typeof this.count === "undefined", `forEach and count are both set, but they are mutually exclusive. You can only use either of them. Check the data source at path: ${this.node.path}`);
        return {
            dependsOn: this.dependsOn,
            count: terraform_count_1.TerraformCount.isTerraformCount(this.count)
                ? this.count.toTerraform()
                : this.count,
            provider: this.provider?.fqn,
            lifecycle: (0, terraform_resource_1.lifecycleToTerraform)(this.lifecycle),
            forEach: this.forEach?._getForEachExpression(),
        };
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    synthesizeHclAttributes() {
        return {};
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toHclTerraform() {
        const attributes = (0, util_1.deepMerge)((0, util_1.processDynamicAttributesForHcl)(this.synthesizeHclAttributes()), (0, util_1.keysToSnakeCase)(this.terraformMetaArguments), this.rawOverrides);
        attributes["//"] = this.constructNodeMetadata;
        return {
            data: {
                [this.terraformResourceType]: {
                    [this.friendlyUniqueId]: attributes,
                },
            },
        };
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        const attributes = (0, util_1.deepMerge)((0, util_1.processDynamicAttributes)(this.synthesizeAttributes()), (0, util_1.keysToSnakeCase)(this.terraformMetaArguments), this.rawOverrides);
        attributes["//"] = this.constructNodeMetadata;
        return {
            data: {
                [this.terraformResourceType]: {
                    [this.friendlyUniqueId]: attributes,
                },
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [this.terraformResourceType]: Object.keys(this.rawOverrides),
            },
        };
    }
    interpolationForAttribute(terraformAttribute) {
        return (0, tfExpression_1.ref)(`data.${this.terraformResourceType}.${this.friendlyUniqueId}${this.forEach ? ".*" : ""}.${terraformAttribute}`, this.cdktfStack);
    }
}
exports.TerraformDataSource = TerraformDataSource;
_a = JSII_RTTI_SYMBOL_1;
TerraformDataSource[_a] = { fqn: "cdktf.TerraformDataSource", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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