import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { TerraformProvider } from "./terraform-provider";
import { TerraformProviderGeneratorMetadata, TerraformResourceConfig, TerraformResourceLifecycle, ITerraformResource } from "./terraform-resource";
import { ITerraformDependable } from "./terraform-dependable";
import { IInterpolatingParent } from "./terraform-addressable";
import { ITerraformIterator } from "./terraform-iterator";
import { TerraformCount } from "./terraform-count";
export declare class TerraformDataSource extends TerraformElement implements ITerraformResource, ITerraformDependable, IInterpolatingParent {
    readonly terraformResourceType: string;
    readonly terraformGeneratorMetadata?: TerraformProviderGeneratorMetadata;
    dependsOn?: string[];
    count?: number | TerraformCount;
    provider?: TerraformProvider;
    lifecycle?: TerraformResourceLifecycle;
    forEach?: ITerraformIterator;
    constructor(scope: Construct, id: string, config: TerraformResourceConfig);
    static isTerraformDataSource(x: any): x is TerraformDataSource;
    getStringAttribute(terraformAttribute: string): string;
    getNumberAttribute(terraformAttribute: string): number;
    getListAttribute(terraformAttribute: string): string[];
    getBooleanAttribute(terraformAttribute: string): import("./tokens").IResolvable;
    getNumberListAttribute(terraformAttribute: string): number[];
    getStringMapAttribute(terraformAttribute: string): {
        [key: string]: string;
    };
    getNumberMapAttribute(terraformAttribute: string): {
        [key: string]: number;
    };
    getBooleanMapAttribute(terraformAttribute: string): {
        [key: string]: boolean;
    };
    getAnyMapAttribute(terraformAttribute: string): {
        [key: string]: any;
    };
    get terraformMetaArguments(): {
        [name: string]: any;
    };
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
    /**
     * Adds this resource to the terraform JSON output.
     */
    toHclTerraform(): any;
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform(): any;
    toMetadata(): any;
    interpolationForAttribute(terraformAttribute: string): import("./tokens").IResolvable;
}
