"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const validate_terraform_version_1 = require("./validations/validate-terraform-version");
const terraform_resource_1 = require("./terraform-resource");
const importable_resource_1 = require("./importable-resource");
const complex_computed_list_1 = require("./complex-computed-list");
const runtime_1 = require("./runtime");
/**
 * The DataResource implements the standard resource lifecycle, but does not directly take any other actions. You can use the DataResource resource without requiring or configuring a provider.
 *
 * The DataResource resource is useful for storing values which need to follow a manage resource lifecycle, and for triggering provisioners when there is no other logical managed resource in which to place them.
 *
 * It requires Terraform 1.4 or later.
 *
 * It is also possible to generate these bindings by adding "terraform.io/builtin/terraform" to the "terraformProviders" key in your cdktf.json file and running "cdktf get".
 *
 * https://developer.hashicorp.com/terraform/language/resources/terraform-data
 */
class DataResource extends terraform_resource_1.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
     * Generates CDKTF code for importing a Data resource upon running "cdktf plan <stack-name>"
     * @param scope The scope in which to define this construct
     * @param importToId The construct id used in the generated config for the Data to import
     * @param importFromId The id of the existing Data that should be imported. Refer to the {@link https://terraform.io/providers/builtin/terraform/latest/docs/resources/data#import import section} in the documentation of this resource for the id to use
     * @param provider? Optional instance of the provider where the Data to import is found
     */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new importable_resource_1.ImportableResource(scope, importToId, {
            terraformResourceType: "terraform_data",
            importId: importFromId,
            provider,
        });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
     * Create a new TerraformData Resource.
     *
     * The DataResource resource is useful for storing values which need to follow a manage resource lifecycle, and for triggering provisioners when there is no other logical managed resource in which to place them.
     *
     * @param scope The scope in which to define this construct
     * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
     * @param options DataConfig = {}
     */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: "terraform_data",
            terraformGeneratorMetadata: {
                providerName: "terraform",
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach,
        });
        // output - computed: true, optional: false, required: false
        this._output = new complex_computed_list_1.AnyMap(this, "output");
        this._input = config.input;
        this._triggersReplace = config.triggersReplace;
        this.node.addValidation(new validate_terraform_version_1.ValidateTerraformVersion(">=1.4", `The built-in Terraform data resource is only supported for Terraform >=1.4. Please upgrade your Terraform version.`));
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute("id");
    }
    get input() {
        return this.getAnyMapAttribute("input");
    }
    /**
     * (Optional) A value which will be stored in the instance state, and reflected in the output attribute after apply.
     * https://developer.hashicorp.com/terraform/language/resources/terraform-data#input
     */
    set input(value) {
        this._input = value;
    }
    resetInput() {
        this._input = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inputInput() {
        return this._input;
    }
    get output() {
        return this._output;
    }
    get triggersReplace() {
        return this.getAnyMapAttribute("triggers_replace");
    }
    /**
     * (Optional) A value which is stored in the instance state, and will force replacement when the value changes.
     * https://developer.hashicorp.com/terraform/language/resources/terraform-data#triggers_replace
     */
    set triggersReplace(value) {
        this._triggersReplace = value;
    }
    resetTriggersReplace() {
        this._triggersReplace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get triggersReplaceInput() {
        return this._triggersReplace;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            input: (0, runtime_1.hashMapper)(runtime_1.anyToTerraform)(this._input),
            triggers_replace: (0, runtime_1.hashMapper)(runtime_1.anyToTerraform)(this._triggersReplace),
        };
    }
    synthesizeHclAttributes() {
        return {
            input: (0, runtime_1.hashMapperHcl)(runtime_1.anyToHclTerraform)(this._input),
            triggers_replace: (0, runtime_1.hashMapperHcl)(runtime_1.anyToHclTerraform)(this._triggersReplace),
        };
    }
}
exports.DataResource = DataResource;
_a = JSII_RTTI_SYMBOL_1;
DataResource[_a] = { fqn: "cdktf.DataResource", version: "0.21.0" };
// =================
// STATIC PROPERTIES
// =================
DataResource.tfResourceType = "terraform_data";
//# sourceMappingURL=data:application/json;base64,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