/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from "constructs";
import { TerraformMetaArguments, TerraformResource } from "./terraform-resource";
import { TerraformProvider } from "./terraform-provider";
import { ImportableResource } from "./importable-resource";
import { AnyMap } from "./complex-computed-list";
export interface DataConfig extends TerraformMetaArguments {
    /**
     * (Optional) A value which will be stored in the instance state, and reflected in the output attribute after apply.
     * https://developer.hashicorp.com/terraform/language/resources/terraform-data#input
     */
    readonly input?: {
        [key: string]: any;
    };
    /**
     * (Optional) A value which is stored in the instance state, and will force replacement when the value changes.
     * https://developer.hashicorp.com/terraform/language/resources/terraform-data#triggers_replace
     */
    readonly triggersReplace?: {
        [key: string]: any;
    };
}
/**
 * The DataResource implements the standard resource lifecycle, but does not directly take any other actions. You can use the DataResource resource without requiring or configuring a provider.
 *
 * The DataResource resource is useful for storing values which need to follow a manage resource lifecycle, and for triggering provisioners when there is no other logical managed resource in which to place them.
 *
 * It requires Terraform 1.4 or later.
 *
 * It is also possible to generate these bindings by adding "terraform.io/builtin/terraform" to the "terraformProviders" key in your cdktf.json file and running "cdktf get".
 *
 * https://developer.hashicorp.com/terraform/language/resources/terraform-data
 */
export declare class DataResource extends TerraformResource {
    static readonly tfResourceType = "terraform_data";
    /**
     * Generates CDKTF code for importing a Data resource upon running "cdktf plan <stack-name>"
     * @param scope The scope in which to define this construct
     * @param importToId The construct id used in the generated config for the Data to import
     * @param importFromId The id of the existing Data that should be imported. Refer to the {@link https://terraform.io/providers/builtin/terraform/latest/docs/resources/data#import import section} in the documentation of this resource for the id to use
     * @param provider? Optional instance of the provider where the Data to import is found
     */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: TerraformProvider): ImportableResource;
    /**
     * Create a new TerraformData Resource.
     *
     * The DataResource resource is useful for storing values which need to follow a manage resource lifecycle, and for triggering provisioners when there is no other logical managed resource in which to place them.
     *
     * @param scope The scope in which to define this construct
     * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
     * @param options DataConfig = {}
     */
    constructor(scope: Construct, id: string, config?: DataConfig);
    get id(): string;
    private _input?;
    get input(): {
        [key: string]: any;
    };
    /**
     * (Optional) A value which will be stored in the instance state, and reflected in the output attribute after apply.
     * https://developer.hashicorp.com/terraform/language/resources/terraform-data#input
     */
    set input(value: {
        [key: string]: any;
    });
    resetInput(): void;
    get inputInput(): {
        [key: string]: any;
    } | undefined;
    private _output;
    get output(): AnyMap;
    private _triggersReplace?;
    get triggersReplace(): {
        [key: string]: any;
    };
    /**
     * (Optional) A value which is stored in the instance state, and will force replacement when the value changes.
     * https://developer.hashicorp.com/terraform/language/resources/terraform-data#triggers_replace
     */
    set triggersReplace(value: {
        [key: string]: any;
    });
    resetTriggersReplace(): void;
    get triggersReplaceInput(): {
        [key: string]: any;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
