"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformCount = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const tfExpression_1 = require("./tfExpression");
const tokens_1 = require("./tokens");
const COUNT_SYMBOL = Symbol.for("cdktf/TerraformCount");
/**
 * Iterator for the Terraform count property
 */
class TerraformCount {
    static of(count) {
        return new TerraformCount(count);
    }
    static isTerraformCount(x) {
        return x !== null && typeof x === "object" && COUNT_SYMBOL in x;
    }
    constructor(count) {
        this.count = count;
        Object.defineProperty(this, COUNT_SYMBOL, { value: true });
    }
    get index() {
        return tokens_1.Token.asNumber((0, tfExpression_1.ref)("count.index"));
    }
    toTerraform() {
        return this.count;
    }
    toString() {
        return this.count.toString();
    }
}
exports.TerraformCount = TerraformCount;
_a = JSII_RTTI_SYMBOL_1;
TerraformCount[_a] = { fqn: "cdktf.TerraformCount", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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