"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const BACKEND_SYMBOL = Symbol.for("cdktf/TerraformBackend");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformBackend extends terraform_element_1.TerraformElement {
    constructor(scope, id, name) {
        super(scope, id);
        this.name = name;
        Object.defineProperty(this, BACKEND_SYMBOL, { value: true });
    }
    static isBackend(x) {
        return x !== null && typeof x === "object" && BACKEND_SYMBOL in x;
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    synthesizeHclAttributes() {
        return {};
    }
    toHclTerraform() {
        return {
            terraform: {
                backend: {
                    [this.name]: (0, util_1.deepMerge)(this.synthesizeHclAttributes(), this.rawOverrides),
                },
            },
        };
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        return {
            terraform: {
                backend: {
                    [this.name]: (0, util_1.deepMerge)(this.synthesizeAttributes(), this.rawOverrides),
                },
            },
        };
    }
    toMetadata() {
        return {
            backend: this.name,
            ...(Object.keys(this.rawOverrides).length > 0
                ? { overrides: { backend: Object.keys(this.rawOverrides) } }
                : {}),
        };
    }
}
exports.TerraformBackend = TerraformBackend;
_a = JSII_RTTI_SYMBOL_1;
TerraformBackend[_a] = { fqn: "cdktf.TerraformBackend", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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