import { TerraformStack } from "../terraform-stack";
import { IStackSynthesizer, ISynthesisSession } from "./types";
import { IConstruct } from "constructs";
export declare class StackSynthesizer implements IStackSynthesizer {
    protected stack: TerraformStack;
    private continueOnErrorAnnotations;
    private hclOutput;
    /**
     * @param stack the stack to synthesize
     * @param continueOnErrorAnnotations if set to true, `synthesize()` will not throw an error
     * if it encounters an error Annotation. However, it will still add all errors to the manifest
     * file. The cdktf-cli uses this flag to print the errors itself.
     */
    constructor(stack: TerraformStack, continueOnErrorAnnotations?: boolean, hclOutput?: boolean);
    synthesize(session: ISynthesisSession): void;
}
/**
 * Invoke aspects on the given construct tree.
 *
 * originally from https://github.com/aws/aws-cdk/blob/dcae3eead0dbf9acb1ed80ba95bb104c64cb1bd7/packages/@aws-cdk/core/lib/private/synthesis.ts#L99-L137
 */
export declare function invokeAspects(root: IConstruct): void;
/**
 * Interface for constructs that want to do something custom during synthesis
 *
 * This feature is intended for use by the CDKTF only; 3rd party
 * library authors and CDK users should not use this function.
 */
export interface ICustomSynthesis {
    /**
     * Called when the construct is synthesized
     */
    onSynthesize(session: ISynthesisSession): void;
}
export declare function addCustomSynthesis(construct: IConstruct, synthesis: ICustomSynthesis): void;
