import { isComplexElement } from "./tokens/private/encoding";
export type Mapper = (x: any) => any;
export declare const stringToTerraform: Mapper;
export declare const booleanToTerraform: Mapper;
export declare const anyToTerraform: Mapper;
export declare const numberToTerraform: Mapper;
export declare const stringToHclTerraform: Mapper;
export declare const booleanToHclTerraform: Mapper;
export declare const anyToHclTerraform: Mapper;
export declare const numberToHclTerraform: Mapper;
/**
 * @param isBlockType blocks and lists of objects need to be handled different in Terraform
 *                    but are represented exactly the same in generated bindings
 *                    currently this is used to resolve TerraformDynamicBlocks if not within
 *                    a block type (will be resolved to a for expression for those instead of
 *                    a dynamic block)
 */
export declare function listMapper(elementMapper: Mapper, isBlockType?: boolean): Mapper;
/**
 * @param isBlockType blocks and lists of objects need to be handled different in Terraform
 *                    but are represented exactly the same in generated bindings
 *                    currently this is used to resolve TerraformDynamicBlocks if not within
 *                    a block type (will be resolved to a for expression for those instead of
 *                    a dynamic block)
 */
export declare function listMapperHcl(elementMapper: Mapper, isBlockType?: boolean): Mapper;
export declare function hashMapper(elementMapper: Mapper): Mapper;
/**
 *
 */
export declare function hashMapperHcl(elementMapper: Mapper): Mapper;
/**
 * Return whether this object can be validated at all
 *
 * True unless it's undefined
 */
export declare function canInspect(x: any): boolean;
export { isComplexElement };
