"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Manifest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const path = require("path");
const fs = require("fs");
// eslint-disable-next-line @typescript-eslint/no-require-imports
const stringify = require("json-stable-stringify");
// eslint-disable-next-line jsdoc/require-jsdoc
class Manifest {
    constructor(version, outdir, hclOutput) {
        this.version = version;
        this.outdir = outdir;
        this.hclOutput = hclOutput;
        this.stacks = {};
        const stacksPath = path.join(this.outdir, Manifest.stacksFolder);
        if (!fs.existsSync(stacksPath))
            fs.mkdirSync(stacksPath);
        this.stackFileName = hclOutput ? "cdk.tf" : "cdk.tf.json";
    }
    forStack(stack) {
        const node = stack.node;
        const name = node.id;
        if (this.stacks[name]) {
            return this.stacks[name];
        }
        const manifest = {
            name,
            constructPath: node.path,
            workingDirectory: path.join(Manifest.stacksFolder, node.id),
            synthesizedStackPath: path.join(Manifest.stacksFolder, node.id, this.stackFileName),
            stackMetadataPath: path.join(Manifest.stacksFolder, node.id, Manifest.stackMetadataPath),
            annotations: [], // will be replaced later when processed in App
            dependencies: stack.dependencies.map((item) => item.node.path),
        };
        this.stacks[name] = manifest;
        return manifest;
    }
    buildManifest() {
        return {
            version: this.version,
            stacks: this.stacks,
        };
    }
    writeToFile() {
        fs.writeFileSync(path.join(this.outdir, Manifest.fileName), stringify(this.buildManifest(), { space: 2 }));
    }
}
exports.Manifest = Manifest;
_a = JSII_RTTI_SYMBOL_1;
Manifest[_a] = { fqn: "cdktf.Manifest", version: "0.21.0" };
Manifest.fileName = "manifest.json";
Manifest.stacksFolder = "stacks";
Manifest.stackMetadataPath = "metadata.json";
//# sourceMappingURL=data:application/json;base64,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