import { TerraformStack } from "./terraform-stack";
import { AnnotationMetadataEntryType } from "./annotations";
export interface StackAnnotation {
    readonly constructPath: string;
    readonly level: AnnotationMetadataEntryType;
    readonly message: string;
    readonly stacktrace?: string[];
}
export interface StackManifest {
    readonly name: string;
    readonly constructPath: string;
    readonly synthesizedStackPath: string;
    readonly stackMetadataPath: string;
    readonly workingDirectory: string;
    readonly annotations: StackAnnotation[];
    readonly dependencies: string[];
}
export interface IManifest {
    readonly stacks: Record<StackManifest["name"], StackManifest>;
    readonly version: string;
}
export declare class Manifest implements IManifest {
    readonly version: string;
    readonly outdir: string;
    readonly hclOutput: boolean;
    static readonly fileName = "manifest.json";
    static readonly stacksFolder = "stacks";
    static readonly stackMetadataPath = "metadata.json";
    readonly stacks: Record<StackManifest["name"], StackManifest>;
    readonly stackFileName: string;
    constructor(version: string, outdir: string, hclOutput: boolean);
    forStack(stack: TerraformStack): StackManifest;
    buildManifest(): IManifest;
    writeToFile(): void;
}
