"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportableResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const validate_terraform_version_1 = require("./validations/validate-terraform-version");
/**
 * Class used to represent an importable resource.
 */
class ImportableResource extends terraform_element_1.TerraformElement {
    constructor(scope, name, config) {
        super(scope, name, config.terraformResourceType);
        this.config = config;
        this.node.addValidation(new validate_terraform_version_1.ValidateTerraformVersion(">=1.5", `Import blocks are only supported for Terraform >=1.5. Please upgrade your Terraform version.`));
    }
    toHclTerraform() {
        const expectedResourceAddress = `${this.config.terraformResourceType}.${this.friendlyUniqueId}`;
        return {
            import: [
                {
                    to: {
                        value: expectedResourceAddress,
                        type: "simple",
                        storageClassType: "reference",
                    },
                    id: {
                        value: this.config.importId,
                        type: "simple",
                        storageClassType: "string",
                    },
                    provider: this.config.provider
                        ? {
                            value: this.config.provider.fqn,
                            type: "simple",
                            storageClassType: "reference",
                        }
                        : undefined,
                },
            ],
        };
    }
    toTerraform() {
        const expectedResourceAddress = `${this.config.terraformResourceType}.${this.friendlyUniqueId}`;
        return {
            import: [
                {
                    to: expectedResourceAddress,
                    id: this.config.importId,
                    provider: this.config.provider ? this.config.provider.fqn : undefined,
                },
            ],
        };
    }
    toMetadata() {
        return {
            importsGeneratingConfiguration: [this.friendlyUniqueId],
        };
    }
}
exports.ImportableResource = ImportableResource;
_a = JSII_RTTI_SYMBOL_1;
ImportableResource[_a] = { fqn: "cdktf.ImportableResource", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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