/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { TerraformProvider } from "./terraform-provider";
export interface IImportableConfig {
    terraformResourceType: string;
    importId: string;
    provider?: TerraformProvider;
}
/**
 * Class used to represent an importable resource.
 */
export declare class ImportableResource extends TerraformElement {
    private readonly config;
    constructor(scope: Construct, name: string, config: IImportableConfig);
    toHclTerraform(): any;
    toTerraform(): any;
    toMetadata(): any;
}
