"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FnGenerated = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
/*
 * This file is generated by tools/generate-function-bindings.
 * To update this file execute 'yarn run generate-function-bindings' in the root of the repository
 */
const helpers_1 = require("./helpers");
// eslint-disable-next-line jsdoc/require-jsdoc
class FnGenerated {
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/abs abs} returns the absolute value of the given number. In other words, if the number is zero or positive then it is returned as-is, but if it is negative then it is multiplied by -1 to make it positive before returning it.
     * @param {number} num
     */
    static abs(num) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("abs", [helpers_1.numericValue])(num));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/abspath abspath} takes a string containing a filesystem path and converts it to an absolute path. That is, if the path is not absolute, it will be joined with the current working directory.
     * @param {string} path
     */
    static abspath(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("abspath", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/alltrue alltrue} returns `true` if all elements in a given collection are `true` or `"true"`. It also returns `true` if the collection is empty.
     * @param {Array<any>} list
     */
    static alltrue(list) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("alltrue", [(0, helpers_1.listOf)(helpers_1.anyValue)])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/anytrue anytrue} returns `true` if any element in a given collection is `true` or `"true"`. It also returns `false` if the collection is empty.
     * @param {Array<any>} list
     */
    static anytrue(list) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("anytrue", [(0, helpers_1.listOf)(helpers_1.anyValue)])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64decode base64decode} takes a string containing a Base64 character sequence and returns the original string.
     * @param {string} str
     */
    static base64decode(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("base64decode", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64encode base64encode} applies Base64 encoding to a string.
     * @param {string} str
     */
    static base64encode(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("base64encode", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64gzip base64gzip} compresses a string with gzip and then encodes the result in Base64 encoding.
     * @param {string} str
     */
    static base64gzip(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("base64gzip", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64sha256 base64sha256} computes the SHA256 hash of a given string and encodes it with Base64. This is not equivalent to `base64encode(sha256("test"))` since `sha256()` returns hexadecimal representation.
     * @param {string} str
     */
    static base64sha256(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("base64sha256", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/base64sha512 base64sha512} computes the SHA512 hash of a given string and encodes it with Base64. This is not equivalent to `base64encode(sha512("test"))` since `sha512()` returns hexadecimal representation.
     * @param {string} str
     */
    static base64sha512(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("base64sha512", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/basename basename} takes a string containing a filesystem path and removes all except the last portion from it.
     * @param {string} path
     */
    static basename(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("basename", [helpers_1.stringValue])(path));
    }
    /**
     * @internal
     * {@link https://developer.hashicorp.com/terraform/language/functions/bcrypt bcrypt} computes a hash of the given string using the Blowfish cipher, returning a string in [the _Modular Crypt Format_](https://passlib.readthedocs.io/en/stable/modular_crypt_format.html) usually expected in the shadow password file on many Unix systems.
     * @param {string} str
     * @param {Array<number>} cost
     */
    static _bcrypt(str, cost) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("bcrypt", [helpers_1.stringValue, (0, helpers_1.variadic)(helpers_1.numericValue)])(str, cost));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/can can} evaluates the given expression and returns a boolean value indicating whether the expression produced a result without any errors.
     * @param {any} expression
     */
    static can(expression) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("can", [helpers_1.anyValue])(expression));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/ceil ceil} returns the closest whole number that is greater than or equal to the given value, which may be a fraction.
     * @param {number} num
     */
    static ceil(num) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("ceil", [helpers_1.numericValue])(num));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/chomp chomp} removes newline characters at the end of a string.
     * @param {string} str
     */
    static chomp(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("chomp", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/chunklist chunklist} splits a single list into fixed-size chunks, returning a list of lists.
     * @param {Array<any>} list
     * @param {number} size
     */
    static chunklist(list, size) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("chunklist", [(0, helpers_1.listOf)(helpers_1.anyValue), helpers_1.numericValue])(list, size));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/cidrhost cidrhost} calculates a full host IP address for a given host number within a given IP network address prefix.
     * @param {string} prefix
     * @param {number} hostnum
     */
    static cidrhost(prefix, hostnum) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("cidrhost", [helpers_1.stringValue, helpers_1.numericValue])(prefix, hostnum));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/cidrnetmask cidrnetmask} converts an IPv4 address prefix given in CIDR notation into a subnet mask address.
     * @param {string} prefix
     */
    static cidrnetmask(prefix) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("cidrnetmask", [helpers_1.stringValue])(prefix));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/cidrsubnet cidrsubnet} calculates a subnet address within given IP network address prefix.
     * @param {string} prefix
     * @param {number} newbits
     * @param {number} netnum
     */
    static cidrsubnet(prefix, newbits, netnum) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("cidrsubnet", [
            helpers_1.stringValue,
            helpers_1.numericValue,
            helpers_1.numericValue,
        ])(prefix, newbits, netnum));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/cidrsubnets cidrsubnets} calculates a sequence of consecutive IP address ranges within a particular CIDR prefix.
     * @param {string} prefix
     * @param {Array<number>} newbits
     */
    static cidrsubnets(prefix, newbits) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("cidrsubnets", [helpers_1.stringValue, (0, helpers_1.variadic)(helpers_1.numericValue)])(prefix, newbits));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/coalesce coalesce} takes any number of arguments and returns the first one that isn't null or an empty string.
     * @param {Array<any>} vals
     */
    static coalesce(vals) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("coalesce", [(0, helpers_1.variadic)(helpers_1.anyValue)])(vals));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/coalescelist coalescelist} takes any number of list arguments and returns the first one that isn't empty.
     * @param {Array<any>} vals
     */
    static coalescelist(vals) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("coalescelist", [(0, helpers_1.variadic)(helpers_1.anyValue)])(vals));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/compact compact} takes a list of strings and returns a new list with any empty string elements removed.
     * @param {Array<string>} list
     */
    static compact(list) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("compact", [(0, helpers_1.listOf)(helpers_1.anyValue)])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/concat concat} takes two or more lists and combines them into a single list.
     * @param {Array<any>} seqs
     */
    static concat(seqs) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("concat", [(0, helpers_1.variadic)(helpers_1.anyValue)])(seqs));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/contains contains} determines whether a given list or set contains a given single value as one of its elements.
     * @param {any} list
     * @param {any} value
     */
    static contains(list, value) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("contains", [helpers_1.anyValue, helpers_1.anyValue])(list, value));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/csvdecode csvdecode} decodes a string containing CSV-formatted data and produces a list of maps representing that data.
     * @param {string} str
     */
    static csvdecode(str) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("csvdecode", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/dirname dirname} takes a string containing a filesystem path and removes the last portion from it.
     * @param {string} path
     */
    static dirname(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("dirname", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/distinct distinct} takes a list and returns a new list with any duplicate elements removed.
     * @param {Array<any>} list
     */
    static distinct(list) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("distinct", [(0, helpers_1.listOf)(helpers_1.anyValue)])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/element element} retrieves a single element from a list.
     * @param {any} list
     * @param {number} index
     */
    static element(list, index) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("element", [helpers_1.anyValue, helpers_1.numericValue])(list, index));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/endswith endswith} takes two values: a string to check and a suffix string. The function returns true if the first string ends with that exact suffix.
     * @param {string} str
     * @param {string} suffix
     */
    static endswith(str, suffix) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("endswith", [helpers_1.stringValue, helpers_1.stringValue])(str, suffix));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/file file} reads the contents of a file at the given path and returns them as a string.
     * @param {string} path
     */
    static file(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("file", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filebase64 filebase64} reads the contents of a file at the given path and returns them as a base64-encoded string.
     * @param {string} path
     */
    static filebase64(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filebase64", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filebase64sha256 filebase64sha256} is a variant of `base64sha256` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filebase64sha256(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filebase64sha256", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filebase64sha512 filebase64sha512} is a variant of `base64sha512` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filebase64sha512(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filebase64sha512", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/fileexists fileexists} determines whether a file exists at a given path.
     * @param {string} path
     */
    static fileexists(path) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("fileexists", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filemd5 filemd5} is a variant of `md5` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filemd5(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filemd5", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/fileset fileset} enumerates a set of regular file names given a path and pattern. The path is automatically removed from the resulting set of file names and any result still containing path separators always returns forward slash (`/`) as the path separator for cross-system compatibility.
     * @param {string} path
     * @param {string} pattern
     */
    static fileset(path, pattern) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("fileset", [helpers_1.stringValue, helpers_1.stringValue])(path, pattern));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filesha1 filesha1} is a variant of `sha1` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filesha1(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filesha1", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filesha256 filesha256} is a variant of `sha256` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filesha256(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filesha256", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/filesha512 filesha512} is a variant of `sha512` that hashes the contents of a given file rather than a literal string.
     * @param {string} path
     */
    static filesha512(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("filesha512", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/flatten flatten} takes a list and replaces any elements that are lists with a flattened sequence of the list contents.
     * @param {any} list
     */
    static flatten(list) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("flatten", [helpers_1.anyValue])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/floor floor} returns the closest whole number that is less than or equal to the given value, which may be a fraction.
     * @param {number} num
     */
    static floor(num) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("floor", [helpers_1.numericValue])(num));
    }
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/format format} function produces a string by formatting a number of other values according to a specification string. It is similar to the `printf` function in C, and other similar functions in other programming languages.
     * @param {string} format
     * @param {Array<any>} args
     */
    static format(format, args) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("format", [helpers_1.stringValue, (0, helpers_1.variadic)(helpers_1.anyValue)])(format, args));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/formatdate formatdate} converts a timestamp into a different time format.
     * @param {string} format
     * @param {string} time
     */
    static formatdate(format, time) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("formatdate", [helpers_1.stringValue, helpers_1.stringValue])(format, time));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/formatlist formatlist} produces a list of strings by formatting a number of other values according to a specification string.
     * @param {string} format
     * @param {Array<any>} args
     */
    static formatlist(format, args) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("formatlist", [helpers_1.stringValue, (0, helpers_1.variadic)(helpers_1.anyValue)])(format, args));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/indent indent} adds a given number of spaces to the beginnings of all but the first line in a given multi-line string.
     * @param {number} spaces
     * @param {string} str
     */
    static indent(spaces, str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("indent", [helpers_1.numericValue, helpers_1.stringValue])(spaces, str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/index index} finds the element index for a given value in a list.
     * @param {any} list
     * @param {any} value
     */
    static index(list, value) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("index", [helpers_1.anyValue, helpers_1.anyValue])(list, value));
    }
    /**
     * @internal
     * {@link https://developer.hashicorp.com/terraform/language/functions/join join} produces a string by concatenating together all elements of a given list of strings with the given delimiter.
     * @param {string} separator
     * @param {Array<Array<string>>} lists
     */
    static _join(separator, lists) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("join", [helpers_1.stringValue, (0, helpers_1.variadic)((0, helpers_1.listOf)(helpers_1.anyValue))])(separator, lists));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/jsondecode jsondecode} interprets a given string as JSON, returning a representation of the result of decoding that string.
     * @param {string} str
     */
    static jsondecode(str) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("jsondecode", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/jsonencode jsonencode} encodes a given value to a string using JSON syntax.
     * @param {any} val
     */
    static jsonencode(val) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("jsonencode", [helpers_1.anyValue])(val));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/keys keys} takes a map and returns a list containing the keys from that map.
     * @param {any} inputMap
     */
    static keys(inputMap) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("keys", [helpers_1.anyValue])(inputMap));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/length length} determines the length of a given list, map, or string.
     * @param {any} value
     */
    static lengthOf(value) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("length", [helpers_1.anyValue])(value));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/log log} returns the logarithm of a given number in a given base.
     * @param {number} num
     * @param {number} base
     */
    static log(num, base) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("log", [helpers_1.numericValue, helpers_1.numericValue])(num, base));
    }
    /**
     * @internal
     * {@link https://developer.hashicorp.com/terraform/language/functions/lookup lookup} retrieves the value of a single element from a map, given its key. If the given key does not exist, the given default value is returned instead.
     * @param {any} inputMap
     * @param {string} key
     * @param {Array<any>} defaultValue
     */
    static _lookup(inputMap, key, defaultValue) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("lookup", [helpers_1.anyValue, helpers_1.stringValue, (0, helpers_1.variadic)(helpers_1.anyValue)])(inputMap, key, defaultValue));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/lower lower} converts all cased letters in the given string to lowercase.
     * @param {string} str
     */
    static lower(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("lower", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/matchkeys matchkeys} constructs a new list by taking a subset of elements from one list whose indexes match the corresponding indexes of values in another list.
     * @param {Array<any>} values
     * @param {Array<any>} keys
     * @param {Array<any>} searchset
     */
    static matchkeys(values, keys, searchset) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("matchkeys", [
            (0, helpers_1.listOf)(helpers_1.anyValue),
            (0, helpers_1.listOf)(helpers_1.anyValue),
            (0, helpers_1.listOf)(helpers_1.anyValue),
        ])(values, keys, searchset));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/max max} takes one or more numbers and returns the greatest number from the set.
     * @param {Array<number>} numbers
     */
    static max(numbers) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("max", [(0, helpers_1.variadic)(helpers_1.numericValue)])(numbers));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/md5 md5} computes the MD5 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} str
     */
    static md5(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("md5", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/merge merge} takes an arbitrary number of maps or objects, and returns a single map or object that contains a merged set of elements from all arguments.
     * @param {Array<any>} maps
     */
    static merge(maps) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("merge", [(0, helpers_1.variadic)(helpers_1.anyValue)])(maps));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/min min} takes one or more numbers and returns the smallest number from the set.
     * @param {Array<number>} numbers
     */
    static min(numbers) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("min", [(0, helpers_1.variadic)(helpers_1.numericValue)])(numbers));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/nonsensitive nonsensitive} takes a sensitive value and returns a copy of that value with the sensitive marking removed, thereby exposing the sensitive value.
     * @param {any} value
     */
    static nonsensitive(value) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("nonsensitive", [helpers_1.anyValue])(value));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/one one} takes a list, set, or tuple value with either zero or one elements. If the collection is empty, `one` returns `null`. Otherwise, `one` returns the first element. If there are two or more elements then `one` will return an error.
     * @param {any} list
     */
    static one(list) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("one", [helpers_1.anyValue])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/parseint parseint} parses the given string as a representation of an integer in the specified base and returns the resulting number. The base must be between 2 and 62 inclusive.
     * @param {any} number
     * @param {number} base
     */
    static parseint(number, base) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("parseint", [helpers_1.anyValue, helpers_1.numericValue])(number, base));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/pathexpand pathexpand} takes a filesystem path that might begin with a `~` segment, and if so it replaces that segment with the current user's home directory path.
     * @param {string} path
     */
    static pathexpand(path) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("pathexpand", [helpers_1.stringValue])(path));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/plantimestamp plantimestamp} returns a UTC timestamp string in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, fixed to a constant time representing the time of the plan.
     */
    static plantimestamp() {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("plantimestamp", [])());
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/pow pow} calculates an exponent, by raising its first argument to the power of the second argument.
     * @param {number} num
     * @param {number} power
     */
    static pow(num, power) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("pow", [helpers_1.numericValue, helpers_1.numericValue])(num, power));
    }
    /**
     * @internal
     * {@link https://developer.hashicorp.com/terraform/language/functions/range range} generates a list of numbers using a start value, a limit value, and a step value.
     * @param {Array<number>} params
     */
    static _range(params) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("range", [(0, helpers_1.variadic)(helpers_1.numericValue)])(params));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/regex regex} applies a [regular expression](https://en.wikipedia.org/wiki/Regular_expression) to a string and returns the matching substrings.
     * @param {string} pattern
     * @param {string} str
     */
    static regex(pattern, str) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("regex", [helpers_1.stringValue, helpers_1.stringValue])(pattern, str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/regexall regexall} applies a [regular expression](https://en.wikipedia.org/wiki/Regular_expression) to a string and returns a list of all matches.
     * @param {string} pattern
     * @param {string} str
     */
    static regexall(pattern, str) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("regexall", [helpers_1.stringValue, helpers_1.stringValue])(pattern, str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/replace replace} searches a given string for another given substring, and replaces each occurrence with a given replacement string.
     * @param {string} str
     * @param {string} substr
     * @param {string} replace
     */
    static replace(str, substr, replace) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("replace", [helpers_1.stringValue, helpers_1.stringValue, helpers_1.stringValue])(str, substr, replace));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/reverse reverse} takes a sequence and produces a new sequence of the same length with all of the same elements as the given sequence but in reverse order.
     * @param {any} list
     */
    static reverse(list) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("reverse", [helpers_1.anyValue])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/rsadecrypt rsadecrypt} decrypts an RSA-encrypted ciphertext, returning the corresponding cleartext.
     * @param {string} ciphertext
     * @param {string} privatekey
     */
    static rsadecrypt(ciphertext, privatekey) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("rsadecrypt", [helpers_1.stringValue, helpers_1.stringValue])(ciphertext, privatekey));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sensitive sensitive} takes any value and returns a copy of it marked so that Terraform will treat it as sensitive, with the same meaning and behavior as for [sensitive input variables](/terraform/language/values/variables#suppressing-values-in-cli-output).
     * @param {any} value
     */
    static sensitive(value) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("sensitive", [helpers_1.anyValue])(value));
    }
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/setintersection setintersection} function takes multiple sets and produces a single set containing only the elements that all of the given sets have in common. In other words, it computes the [intersection](https://en.wikipedia.org/wiki/Intersection_\(set_theory\)) of the sets.
     * @param {Array<any>} first_set
     * @param {Array<Array<any>>} other_sets
     */
    static setintersection(first_set, other_sets) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("setintersection", [
            (0, helpers_1.listOf)(helpers_1.anyValue),
            (0, helpers_1.variadic)((0, helpers_1.listOf)(helpers_1.anyValue)),
        ])(first_set, other_sets));
    }
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/setproduct setproduct} function finds all of the possible combinations of elements from all of the given sets by computing the [Cartesian product](https://en.wikipedia.org/wiki/Cartesian_product).
     * @param {Array<any>} sets
     */
    static setproduct(sets) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("setproduct", [(0, helpers_1.variadic)(helpers_1.anyValue)])(sets));
    }
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/setsubtract setsubtract} function returns a new set containing the elements from the first set that are not present in the second set. In other words, it computes the [relative complement](https://en.wikipedia.org/wiki/Complement_\(set_theory\)#Relative_complement) of the second set.
     * @param {Array<any>} a
     * @param {Array<any>} b
     */
    static setsubtract(a, b) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("setsubtract", [(0, helpers_1.listOf)(helpers_1.anyValue), (0, helpers_1.listOf)(helpers_1.anyValue)])(a, b));
    }
    /**
     * The {@link https://developer.hashicorp.com/terraform/language/functions/setunion setunion} function takes multiple sets and produces a single set containing the elements from all of the given sets. In other words, it computes the [union](https://en.wikipedia.org/wiki/Union_\(set_theory\)) of the sets.
     * @param {Array<any>} first_set
     * @param {Array<Array<any>>} other_sets
     */
    static setunion(first_set, other_sets) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("setunion", [
            (0, helpers_1.listOf)(helpers_1.anyValue),
            (0, helpers_1.variadic)((0, helpers_1.listOf)(helpers_1.anyValue)),
        ])(first_set, other_sets));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sha1 sha1} computes the SHA1 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} str
     */
    static sha1(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("sha1", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sha256 sha256} computes the SHA256 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} str
     */
    static sha256(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("sha256", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sha512 sha512} computes the SHA512 hash of a given string and encodes it with hexadecimal digits.
     * @param {string} str
     */
    static sha512(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("sha512", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/signum signum} determines the sign of a number, returning a number between -1 and 1 to represent the sign.
     * @param {number} num
     */
    static signum(num) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("signum", [helpers_1.numericValue])(num));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/slice slice} extracts some consecutive elements from within a list.
     * @param {any} list
     * @param {number} start_index
     * @param {number} end_index
     */
    static slice(list, start_index, end_index) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("slice", [helpers_1.anyValue, helpers_1.numericValue, helpers_1.numericValue])(list, start_index, end_index));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sort sort} takes a list of strings and returns a new list with those strings sorted lexicographically.
     * @param {Array<string>} list
     */
    static sort(list) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("sort", [(0, helpers_1.listOf)(helpers_1.anyValue)])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/split split} produces a list by dividing a given string at all occurrences of a given separator.
     * @param {string} separator
     * @param {string} str
     */
    static split(separator, str) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("split", [helpers_1.stringValue, helpers_1.stringValue])(separator, str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/startswith startswith} takes two values: a string to check and a prefix string. The function returns true if the string begins with that exact prefix.
     * @param {string} str
     * @param {string} prefix
     */
    static startswith(str, prefix) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("startswith", [helpers_1.stringValue, helpers_1.stringValue])(str, prefix));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/strcontains strcontains} takes two values: a string to check and an expected substring. The function returns true if the string has the substring contained within it.
     * @param {string} str
     * @param {string} substr
     */
    static strcontains(str, substr) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("strcontains", [helpers_1.stringValue, helpers_1.stringValue])(str, substr));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/strrev strrev} reverses the characters in a string. Note that the characters are treated as _Unicode characters_ (in technical terms, Unicode [grapheme cluster boundaries](https://unicode.org/reports/tr29/#Grapheme_Cluster_Boundaries) are respected).
     * @param {string} str
     */
    static strrev(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("strrev", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/substr substr} extracts a substring from a given string by offset and (maximum) length.
     * @param {string} str
     * @param {number} offset
     * @param {number} length
     */
    static substr(str, offset, length) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("substr", [helpers_1.stringValue, helpers_1.numericValue, helpers_1.numericValue])(str, offset, length));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/sum sum} takes a list or set of numbers and returns the sum of those numbers.
     * @param {any} list
     */
    static sum(list) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("sum", [helpers_1.anyValue])(list));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/templatefile templatefile} reads the file at the given path and renders its content as a template using a supplied set of template variables.
     * @param {string} path
     * @param {any} vars
     */
    static templatefile(path, vars) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("templatefile", [helpers_1.stringValue, helpers_1.anyValue])(path, vars));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/textdecodebase64 textdecodebase64} function decodes a string that was previously Base64-encoded, and then interprets the result as characters in a specified character encoding.
     * @param {string} source
     * @param {string} encoding
     */
    static textdecodebase64(source, encoding) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("textdecodebase64", [helpers_1.stringValue, helpers_1.stringValue])(source, encoding));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/textencodebase64 textencodebase64} encodes the unicode characters in a given string using a specified character encoding, returning the result base64 encoded because Terraform language strings are always sequences of unicode characters.
     * @param {string} str
     * @param {string} encoding
     */
    static textencodebase64(str, encoding) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("textencodebase64", [helpers_1.stringValue, helpers_1.stringValue])(str, encoding));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/timeadd timeadd} adds a duration to a timestamp, returning a new timestamp.
     * @param {string} timestamp
     * @param {string} duration
     */
    static timeadd(timestamp, duration) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("timeadd", [helpers_1.stringValue, helpers_1.stringValue])(timestamp, duration));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/timecmp timecmp} compares two timestamps and returns a number that represents the ordering of the instants those timestamps represent.
     * @param {string} timestamp_a
     * @param {string} timestamp_b
     */
    static timecmp(timestamp_a, timestamp_b) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("timecmp", [helpers_1.stringValue, helpers_1.stringValue])(timestamp_a, timestamp_b));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/timestamp timestamp} returns a UTC timestamp string in [RFC 3339](https://tools.ietf.org/html/rfc3339) format.
     */
    static timestamp() {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("timestamp", [])());
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/title title} converts the first letter of each word in the given string to uppercase.
     * @param {string} str
     */
    static title(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("title", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tobool tobool} converts its argument to a boolean value.
     * @param {any} v
     */
    static tobool(v) {
        return (0, helpers_1.asBoolean)((0, helpers_1.terraformFunction)("tobool", [helpers_1.anyValue])(v));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tolist tolist} converts its argument to a list value.
     * @param {any} v
     */
    static tolist(v) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("tolist", [helpers_1.anyValue])(v));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tomap tomap} converts its argument to a map value.
     * @param {any} v
     */
    static tomap(v) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("tomap", [helpers_1.anyValue])(v));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tonumber tonumber} converts its argument to a number value.
     * @param {any} v
     */
    static tonumber(v) {
        return (0, helpers_1.asNumber)((0, helpers_1.terraformFunction)("tonumber", [helpers_1.anyValue])(v));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/toset toset} converts its argument to a set value.
     * @param {any} v
     */
    static toset(v) {
        return (0, helpers_1.asList)((0, helpers_1.terraformFunction)("toset", [helpers_1.anyValue])(v));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/tostring tostring} converts its argument to a string value.
     * @param {any} v
     */
    static tostring(v) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("tostring", [helpers_1.anyValue])(v));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/transpose transpose} takes a map of lists of strings and swaps the keys and values to produce a new map of lists of strings.
     * @param {Object<string, Array<string>>} values
     */
    static transpose(values) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("transpose", [helpers_1.mapValue])(values));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/trim trim} removes the specified set of characters from the start and end of the given string.
     * @param {string} str
     * @param {string} cutset
     */
    static trim(str, cutset) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("trim", [helpers_1.stringValue, helpers_1.stringValue])(str, cutset));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/trimprefix trimprefix} removes the specified prefix from the start of the given string. If the string does not start with the prefix, the string is returned unchanged.
     * @param {string} str
     * @param {string} prefix
     */
    static trimprefix(str, prefix) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("trimprefix", [helpers_1.stringValue, helpers_1.stringValue])(str, prefix));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/trimspace trimspace} removes any space characters from the start and end of the given string.
     * @param {string} str
     */
    static trimspace(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("trimspace", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/trimsuffix trimsuffix} removes the specified suffix from the end of the given string.
     * @param {string} str
     * @param {string} suffix
     */
    static trimsuffix(str, suffix) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("trimsuffix", [helpers_1.stringValue, helpers_1.stringValue])(str, suffix));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/try try} evaluates all of its argument expressions in turn and returns the result of the first one that does not produce any errors.
     * @param {Array<any>} expressions
     */
    static try(expressions) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("try", [(0, helpers_1.variadic)(helpers_1.anyValue)])(expressions));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/upper upper} converts all cased letters in the given string to uppercase.
     * @param {string} str
     */
    static upper(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("upper", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/urlencode urlencode} applies URL encoding to a given string.
     * @param {string} str
     */
    static urlencode(str) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("urlencode", [helpers_1.stringValue])(str));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/uuid uuid} generates a unique identifier string.
     */
    static uuid() {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("uuid", [])());
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/uuidv5 uuidv5} generates a _name-based_ UUID, as described in [RFC 4122 section 4.3](https://tools.ietf.org/html/rfc4122#section-4.3), also known as a "version 5" UUID.
     * @param {string} namespace
     * @param {string} name
     */
    static uuidv5(namespace, name) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("uuidv5", [helpers_1.stringValue, helpers_1.stringValue])(namespace, name));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/values values} takes a map and returns a list containing the values of the elements in that map.
     * @param {any} mapping
     */
    static values(mapping) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("values", [helpers_1.anyValue])(mapping));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/yamldecode yamldecode} parses a string as a subset of YAML, and produces a representation of its value.
     * @param {string} src
     */
    static yamldecode(src) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("yamldecode", [helpers_1.stringValue])(src));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/yamlencode yamlencode} encodes a given value to a string using [YAML 1.2](https://yaml.org/spec/1.2/spec.html) block syntax.
     * @param {any} value
     */
    static yamlencode(value) {
        return (0, helpers_1.asString)((0, helpers_1.terraformFunction)("yamlencode", [helpers_1.anyValue])(value));
    }
    /**
     * {@link https://developer.hashicorp.com/terraform/language/functions/zipmap zipmap} constructs a map from a list of keys and a corresponding list of values.
     * @param {Array<string>} keys
     * @param {any} values
     */
    static zipmap(keys, values) {
        return (0, helpers_1.asAny)((0, helpers_1.terraformFunction)("zipmap", [(0, helpers_1.listOf)(helpers_1.anyValue), helpers_1.anyValue])(keys, values));
    }
}
exports.FnGenerated = FnGenerated;
_a = JSII_RTTI_SYMBOL_1;
FnGenerated[_a] = { fqn: "cdktf.FnGenerated", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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