"use strict";
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
// --------------------------------------------------------------------------------
// This file defines context keys that enable certain features that are
// implemented behind a flag in order to preserve backwards compatibility for
// existing apps. When a new app is initialized through `cdk init`, the CLI will
// automatically add enable these features by adding them to the generated
// `cdktf.json` file. In the next major release of the CDK for Terraform, these feature flags
// will be removed and will become the default behavior.
// --------------------------------------------------------------------------------
Object.defineProperty(exports, "__esModule", { value: true });
exports.FUTURE_FLAGS = void 0;
/**
 * This map includes context keys and values for feature flags that enable
 * capabilities "from the future", which we could not introduce as the default
 * behavior due to backwards compatibility for existing projects.
 *
 * New projects generated through `cdktf init` will include these flags in their
 * generated `cdktf.json` file.
 *
 * When we release the next major version of the CDK for Terraform, we will flip the logic of
 * these features and clean up the `cdktf.json` generated by `cdktf init`.
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
exports.FUTURE_FLAGS = {};
//# sourceMappingURL=data:application/json;base64,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