"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.unableToResolveCircularReference = exports.intrinsicNewError = exports.argToIntrinsicMustBePlainValue = exports.indexTooLargeToEncode = exports.canOnlyEncodePositiveIntegers = exports.doesNotImplementDependableTrait = exports.cannotConcatenateStringsInTokenizedMap = exports.mapValueAddedToReferenceList = exports.numberValueAddedToReferenceList = exports.cannotConcatenateStringsInTokenizedStringArray = exports.stringValueAddedToReferenceList = exports.cannotCalcIdForEmptySetOfComponents = exports.functionArgumentValidationFailure = exports.functionReceivedWrongNumberOfArgs = exports.listElementIsOfWrongType = exports.valueIsInvalidNumberOrToken = exports.valueIsInvalidStringOrToken = exports.encounteredAnnotationWithLevelError = exports.valueContainsUnescapedQuotes = exports.cloudBackendWorkspaceIsNotDefinedByName = exports.constructDependencyBelowV10 = exports.sourceOrTargetNotAnObject = exports.targetNotResolvableWithOverrides = exports.invalidStack = exports.expectNotGloballyAccessible = exports.jestNotInstantiated = exports.matchersFoundErrorsInStack = exports.matchersPathIsNotDirectory = exports.stackValidationFailure = exports.stackHasCircularDependency = exports.noStackForConstruct = exports.stackIdContainsWhitespace = exports.stackContainsDisallowedChar = exports.resourceGivenTwoMoveOperationsByTarget = exports.resourceGivenTwoMoveOperationsById = exports.resourceGivenTwoMoveOperationsByTargetAndId = exports.movedToResourceOfDifferentType = exports.moveTargetNotSet = exports.moveTargetAlreadySet = exports.modulesWithSameAlias = exports.iteratorOnResourceWithoutForEach = exports.iteratorOnResourceWithCount = exports.unresolvedTokenInConstructId = exports.dynamicBlockNotSupported = exports.assetTypeNotImplemented = exports.assetExpectsDirectory = exports.assetOutOfScopeOfCDKTFJson = exports.providerVersionMismatch = exports.appValidationFailure = exports.noAppFound = void 0;
exports.terraformModuleHasChildren = exports.assetCanNotCreateZipArchive = exports.IdIncludesUnresolvedTokens = exports.unrecognizedTokenKey = exports.unknownNumberTokenFound = exports.mapKeyMustResolveToString = exports.constructsCannotBeResolved = exports.encodedMapTokenInScalarNumberContext = exports.encodedMapTokenInScalarStringContext = exports.encodedListTokenInScalarStringContext = exports.cannotResolveFunction = void 0;
const noAppFound = (constructPath) => new Error(`No app could be identified for the construct at path '${constructPath}' (likely a TerraformStack).
The scope of CDKTF's TerraformStack class is a single App instance created by 'const app = new App()'. The App is your project's root, holding project configuration and validations.
Learn more about the App: https://developer.hashicorp.com/terraform/cdktf/concepts/cdktf-architecture#app-class:~:text=and%20Resource.-,App%20Class,-Each%20CDKTF%20project
    `);
exports.noAppFound = noAppFound;
const appValidationFailure = (errorList) => new Error(`App-level validation failed with the following errors:\n  ${errorList}
Validations allow for dynamic verification of your project.
To skip validations, add 'skipValidation: true' to your App config.
    `);
exports.appValidationFailure = appValidationFailure;
const providerVersionMismatch = () => new Error(`Version mismatch detected: Your provider bindings are built for an older version of CDKTF.
Upgrade your pre-built provider or re-run cdktf get with a more recent version (>= 0.10) of the cdktf-cli.
    `);
exports.providerVersionMismatch = providerVersionMismatch;
const assetOutOfScopeOfCDKTFJson = (id, configPath) => new Error(`TerraformAsset ${id} was created with a relative path '${configPath}', but we cannot find the cdktf.json within your current working directory '${process.cwd()}'

The cdktf.json file is needed to establish the base for the relative path (the '.' in './foo/bar').

Place a cdktf.json at the root of your project. Learn more: https://developer.hashicorp.com/terraform/cdktf/create-and-deploy/configuration-file
Learn more about TerraformAsset: https://developer.hashicorp.com/terraform/cdktf/concepts/assets
`);
exports.assetOutOfScopeOfCDKTFJson = assetOutOfScopeOfCDKTFJson;
const assetExpectsDirectory = (id, configPath) => new Error(`TerraformAsset ${id} expects path to point to a directory. Instead, this file was passed: '${configPath}'. Please correct the path to point to a directory.
Learn more about TerraformAsset: https://developer.hashicorp.com/terraform/cdktf/concepts/assets
    `);
exports.assetExpectsDirectory = assetExpectsDirectory;
const assetTypeNotImplemented = () => new Error(`Asset type is not implemented.
Possible Asset types include: FILE, DIRECTORY, and ARCHIVE.
Take one of these values from the AssetType Enum.
Learn more about TerraformAsset: https://developer.hashicorp.com/terraform/cdktf/concepts/assets
  `);
exports.assetTypeNotImplemented = assetTypeNotImplemented;
const dynamicBlockNotSupported = (_foreachExpression) => new Error(`We do not support directly resolving a TerraformDynamicBlock. Dynamic blocks are only supported on block attributes of resources, data sources, and providers.

You can create a TerraformDynamicBlock by calling '.dynamic' on a TerraformIterator instance.

The following expression was used for the dynamic block: .dynamic({
  ${_foreachExpression}
})
`);
exports.dynamicBlockNotSupported = dynamicBlockNotSupported;
const unresolvedTokenInConstructId = (id) => new Error(`You cannot use a token (e.g., a reference to an attribute) as the id of a construct. Ids of constructs must be known at synthesis time, and token values are only known when Terraform runs. Please use a concrete value for your constructs ID instead.
You passed the following id: "${id}"
`);
exports.unresolvedTokenInConstructId = unresolvedTokenInConstructId;
const iteratorOnResourceWithCount = () => new Error(`You cannot create an iterator from a resource with a count argument.
Instead, reuse this resource's TerraformCount instance in the resource you want to use as an iterator.

If you want to use an iterator to populate a list attribute, replace the count on the resource with an iterator passed into the forEach argument.`);
exports.iteratorOnResourceWithCount = iteratorOnResourceWithCount;
const iteratorOnResourceWithoutForEach = () => new Error(`Cannot create an iterator from a resource without a forEach argument. If you want to create more instances of this resource, pass an iterator to the forEach argument of the resource first.
  `);
exports.iteratorOnResourceWithoutForEach = iteratorOnResourceWithoutForEach;
const modulesWithSameAlias = (alias) => new Error(`Multiple providers have the same alias: "${alias}"
Each provider must have a unique alias when passing multiple providers of the same type to modules.
  `);
exports.modulesWithSameAlias = modulesWithSameAlias;
const moveTargetAlreadySet = (target, friendlyUniqueId) => new Error(`Target "${target}" has already been used for the construct ${friendlyUniqueId}.
Target must be a string that is unique across all resources in the same stack.`);
exports.moveTargetAlreadySet = moveTargetAlreadySet;
const moveTargetNotSet = (target, entries) => new Error(`Target "${target}" has not been set.
You tried to move a resource without a target.
Call .addMoveTarget("${target}") on the instance of the resource you want to move this resource to.

Alternatively, you can use one of the following targets (in case you had a typo):
${entries}
`);
exports.moveTargetNotSet = moveTargetNotSet;
const movedToResourceOfDifferentType = (moveTarget, originalResourceType, destinationResourceType) => new Error(`We do not support moving resources to a different type.

The destination "${moveTarget}"'s resource type ${destinationResourceType} differs from the original resource type (${originalResourceType}) you are trying to move.

If this was intentional, try importing the existing resource into your target instead. Learn more:
https://developer.hashicorp.com/terraform/cdktf/concepts/resources#importing-resources

Note that you must manually remove the original resource from your state file after importing it. Use the "terraform state rm" command in the output directory of the stack you defined this resource in. Learn more:
https://developer.hashicorp.com/terraform/cli/commands/state/rm
`);
exports.movedToResourceOfDifferentType = movedToResourceOfDifferentType;
const resourceGivenTwoMoveOperationsByTargetAndId = (id, existingTarget, newMove) => new Error(`
The resource ${id} has been given two different move operations.

Move target: "${existingTarget}"
Move by id: {
  from: ${newMove.from}
  to: ${newMove.to}
}

Only one move operation can occur per plan/apply. Remove one of the operations.

Learn more about moving resources: https://developer.hashicorp.com/terraform/cdktf/examples-and-guides/refactoring#:~:text=Moving%20%26%20Renaming%20Resources%20Within%20a%20Stack
`);
exports.resourceGivenTwoMoveOperationsByTargetAndId = resourceGivenTwoMoveOperationsByTargetAndId;
const resourceGivenTwoMoveOperationsById = (id, existingMove, newMove) => new Error(`
The resource ${id} has been given two different move operations.

{
  from: ${existingMove.from}
  to: ${existingMove.to}
}
{
  from: ${newMove.from}
  to: ${newMove.to} (Resource calling the move to operation)
}

Only one move operation can occur per plan/apply. Remove one of the operations.

Learn more about moving resources: https://developer.hashicorp.com/terraform/cdktf/examples-and-guides/refactoring#:~:text=Moving%20%26%20Renaming%20Resources%20Within%20a%20Stack
`);
exports.resourceGivenTwoMoveOperationsById = resourceGivenTwoMoveOperationsById;
const resourceGivenTwoMoveOperationsByTarget = (resourceId, existingMoveTarget, newMoveTarget) => new Error(`The resource ${resourceId} has been given two different moveTargets: "${newMoveTarget}" and "${existingMoveTarget}"

A resource can only be moved once per plan/apply.

Learn more about moving resources: https://developer.hashicorp.com/terraform/cdktf/examples-and-guides/refactoring#:~:text=Moving%20%26%20Renaming%20Resources%20Within%20a%20Stack
`);
exports.resourceGivenTwoMoveOperationsByTarget = resourceGivenTwoMoveOperationsByTarget;
const stackContainsDisallowedChar = (stackId, invalidChar) => new Error(`Cannot create Terraform stack with id "${stackId}". It contains an invalid glob character: "${invalidChar}".

Glob characters are not supported in stack names because we use them to deploy and destroy multiple stacks. For example, 'cdktf deploy \`*-production\`' deploys all stacks with names that end in '-production'.
`);
exports.stackContainsDisallowedChar = stackContainsDisallowedChar;
const stackIdContainsWhitespace = (stackId) => new Error(`Cannot create TerraformStack with id "${stackId}". It contains a whitespace character.

Please remove any whitespace characters in your TerraformStack id, like so: "${stackId.replace(/\s/g, "")}"
`);
exports.stackIdContainsWhitespace = stackIdContainsWhitespace;
const noStackForConstruct = (constructPath, hint) => new Error(`No stack could be identified for the construct at path '${constructPath}'${hint}

You can only use constructs as part of a TerraformStack.

To learn more about Constructs vs. TerraformStacks, refer to: https://developer.hashicorp.com/terraform/cdktf/concepts/constructs#:~:text=Constructs%20vs.%20Stacks
`);
exports.noStackForConstruct = noStackForConstruct;
const stackHasCircularDependency = (thisStack, dependency) => new Error(`Cannot add dependency ${dependency} to ${thisStack}, because it would cause a circular dependency.

TerraformStack ${dependency} is already dependent on ${thisStack} directly, or dependent on a TerraformStack within ${thisStack}.

To learn more about circular dependency references, refer to: https://developer.hashicorp.com/terraform/cdktf/concepts/stacks#:~:text=Cross%2DStack%20References
`);
exports.stackHasCircularDependency = stackHasCircularDependency;
const stackValidationFailure = (errorList) => new Error(`Validation failed with the following errors:\n  ${errorList}

If you wish to ignore these validations, pass 'skipValidation: true' to your App configuration.
`);
exports.stackValidationFailure = stackValidationFailure;
const matchersPathIsNotDirectory = (functionName) => new Error(`Path is not a directory.

Ensure you are passing the result of Testing.fullSynth('stack instance') to '${functionName}', not Testing.synth('stack instance').

Testing.fullSynth returns a file path to a temporary testing environment. Testing.synth returns the JSON representation of your stack.

To learn more about testing in CDKTF, refer to: https://developer.hashicorp.com/terraform/cdktf/test/unit-tests`);
exports.matchersPathIsNotDirectory = matchersPathIsNotDirectory;
const matchersFoundErrorsInStack = (errorCount, stackName, diagnostics) => new Error(`Found ${errorCount} Errors in stack ${stackName}: ${diagnostics}

These errors are not test failures, but issues with the underlying TerraformStack being tested. Fix the above issues before running your tests again.
`);
exports.matchersFoundErrorsInStack = matchersFoundErrorsInStack;
const jestNotInstantiated = () => new Error(`Jest was not properly instantiated.

Ensure you have a 'setup.js' file in your project's directory that calls 'cdktf.Testing.setupJest()'.

To learn more about setting up testing, refer to: https://developer.hashicorp.com/terraform/cdktf/test/unit-tests#:~:text=Add%20Testing%20to%20Your%20Application
`);
exports.jestNotInstantiated = jestNotInstantiated;
const expectNotGloballyAccessible = () => new Error(`The expect function is not globally accessible.

To learn more about setting up testing, refer to: https://developer.hashicorp.com/terraform/cdktf/test/unit-tests#:~:text=Add%20Testing%20to%20Your%20Application
`);
exports.expectNotGloballyAccessible = expectNotGloballyAccessible;
const invalidStack = (functionName, stackContent) => new Error(`Invalid JSON string passed: ${stackContent}


Ensure you are passing the result of Testing.synth('stack instance') to '${functionName}', not Testing.fullSynth('stack instance').


Testing.synth returns the JSON representation of your stack. CDKTF can use assertions with this JSON to check the composition of your stacks, like so: "Testing.toHaveResource(Testing.synth('TerraformStack instance'), S3Bucket)"

Testing.fullSynth returns a file path to a temporary testing environment.

To learn more about testing in CDKTF, refer to: https://developer.hashicorp.com/terraform/cdktf/test/unit-tests
`);
exports.invalidStack = invalidStack;
const targetNotResolvableWithOverrides = (target) => new Error(`Target (${target}) cannot be a resolvable token if you specified overrides. Replace the value of the field you are overriding with a static value.

To learn more about Tokens, refer to: https://developer.hashicorp.com/terraform/cdktf/concepts/tokens
`);
exports.targetNotResolvableWithOverrides = targetNotResolvableWithOverrides;
const sourceOrTargetNotAnObject = (source, sourceType, target, targetType) => new Error(`An issue occurred during the synthesization of your Terraform configuration.

Both the source element (${source}) and its containing target element (${target}) must be objects.

Type of source: ${sourceType}
Type of target: ${targetType}
`);
exports.sourceOrTargetNotAnObject = sourceOrTargetNotAnObject;
const constructDependencyBelowV10 = () => new Error(`Version mismatch! CDKTF version 0.6 requires your constructs version to be v10 or above.

Update your constructs dependency: https://cdk.tf/upgrade-constructs-v10
`);
exports.constructDependencyBelowV10 = constructDependencyBelowV10;
const cloudBackendWorkspaceIsNotDefinedByName = () => new Error(`The Cloud backend only supports cross-stack references if the workspace is defined by name (not by tags).

To use cross-stack references, replace all mentions of 'TaggedCloudWorkspaces' with 'NamedCloudWorkspace', like so:

new CloudBackend(stack, {
  ...
  workspaces: new NamedCloudWorkspace("my-app"),
});

To learn more about Remote Backends, refer to: https://developer.hashicorp.com/terraform/cdktf/concepts/remote-backends
`);
exports.cloudBackendWorkspaceIsNotDefinedByName = cloudBackendWorkspaceIsNotDefinedByName;
const valueContainsUnescapedQuotes = (value) => new Error(`Your value, '${value}', has unescaped double quotes in it, so it cannot be used as a value.

To safely use the value, use Fn.rawString on your string, like so:

Fn.rawString('${value}')

Doing this ensures CDKTF and Terraform interpret your values correctly.

To learn more about built in Terraform functions within CDKTF, refer to: https://developer.hashicorp.com/terraform/cdktf/concepts/functions
`);
exports.valueContainsUnescapedQuotes = valueContainsUnescapedQuotes;
const encounteredAnnotationWithLevelError = (errors) => new Error(`Encountered Annotations with level "ERROR":\n${errors}

Either fix the issues above, or set the environment variable CDKTF_CONTINUE_SYNTH_ON_ERROR_ANNOTATIONS to ignore these annotations.
`);
exports.encounteredAnnotationWithLevelError = encounteredAnnotationWithLevelError;
const valueIsInvalidStringOrToken = (value) => new Error(`'${value}' is not a valid string nor a token. This function only accepts strings or tokens resolving to strings. Please change your code accordingly.`);
exports.valueIsInvalidStringOrToken = valueIsInvalidStringOrToken;
const valueIsInvalidNumberOrToken = (value) => new Error(`${value} is not a valid number nor a token. This function only accepts numbers or tokens resolving to numbers. Please change your code accordingly.`);
exports.valueIsInvalidNumberOrToken = valueIsInvalidNumberOrToken;
const listElementIsOfWrongType = (value, position, error) => new Error(`Element in list ${value} at position ${position} is not the right type: ${error}.
    Please ensure all elements in the list are the correct type for this function.`);
exports.listElementIsOfWrongType = listElementIsOfWrongType;
const functionReceivedWrongNumberOfArgs = (name, argValidatorsLength, argsLength) => new Error(`Function ${name} takes ${argValidatorsLength} arguments, but ${argsLength} were provided. Please add the missing arguments to the function.`);
exports.functionReceivedWrongNumberOfArgs = functionReceivedWrongNumberOfArgs;
const functionArgumentValidationFailure = (argNumber, name, error) => new Error(`Argument ${argNumber} of ${name} failed the validation: ${error}. Please change your code to pass a valid value for this argument.`);
exports.functionArgumentValidationFailure = functionArgumentValidationFailure;
const cannotCalcIdForEmptySetOfComponents = () => new Error(`Unable to calculate a unique id for an empty set of components.

    This happens when you attempt to create a unique id, but do not pass in any construct node ids. This means your construct likely has no parent, which is not allowed.

    Please make sure your construct has a parent. For example: 'new App(this)' or 'new TerraformStack(this, 'stack')'.`);
exports.cannotCalcIdForEmptySetOfComponents = cannotCalcIdForEmptySetOfComponents;
const stringValueAddedToReferenceList = (listToken) => new Error(`Cannot add elements to list token, got: ${listToken}.

    We expect the elements of a tokenized string array to be a single token string. For example, ["&{TfToken[Token.1]}"].

    One element in your array consists of more than a single value. To add values to a tokenized list, use Terraform functions instead. For example: 'Fn.concat([yourReferencedList, ["my", "new", "items"]])'.`);
exports.stringValueAddedToReferenceList = stringValueAddedToReferenceList;
const cannotConcatenateStringsInTokenizedStringArray = (listToken) => new Error(`Cannot concatenate strings in a tokenized string array, got: ${listToken}.

    We expect the elements of a tokenized string array to be a single token string. For example, ["&{TfToken[Token.1]}"]. One element in your array consists of something other than a single token.

    You are likely mutating the value inside your array, which CDKTF cannot resolve into the appropriate runtime value.`);
exports.cannotConcatenateStringsInTokenizedStringArray = cannotConcatenateStringsInTokenizedStringArray;
const numberValueAddedToReferenceList = (listToken) => new Error(`Cannot add elements to list token, got: ${listToken}.

    We use tokens to represent runtime values (e.g., references to attributes of resource or data sources). List tokens don't contain the actual values because those are only available at apply time, whereas tokens are present during compile time.

    If you want to add a value to a tokenized list, use a Terraform function instead. For example: Fn.concat([yourReferencedList, [42, 43, 44]]).`);
exports.numberValueAddedToReferenceList = numberValueAddedToReferenceList;
const mapValueAddedToReferenceList = (mapToken) => new Error(`Cannot add elements to map token, got: ${mapToken}. This can happen if you merge multiple maps, or if you add a new key value pair to the map token.

    We use tokens to represent runtime values (e.g., references to attributes of resource or data sources). List tokens don't contain the actual values because those are only available at apply time, whereas tokens are present during compile time.

    Instead of adding the value to the tokenized map, use a Terraform function. For example: Fn.merge([yourReferencedMap, { your: 'value' }]). This creates a new map Token for a value, which could get rendered as:
    merge(my_resource.resource_name.one_specific_map_attribute, { your: ' value' })`);
exports.mapValueAddedToReferenceList = mapValueAddedToReferenceList;
const cannotConcatenateStringsInTokenizedMap = (tokenizedMap) => new Error(`Cannot concatenate strings in a tokenized map, got: ${tokenizedMap}.

    We expect the elements of a tokenized string array to be a single token string. For example, ["&{TfToken[Token.1]}"]. A key in your map consists of more than a string token (e.g., the Token and a static string or multiple Tokens).

    This can happen if you mutate the key of the map. Do not mutate tokenized Maps, because it makes it impossible for CDKTF to translate them.`);
exports.cannotConcatenateStringsInTokenizedMap = cannotConcatenateStringsInTokenizedMap;
const doesNotImplementDependableTrait = (instance) => new Error(`${instance} does not implement DependableTrait`);
exports.doesNotImplementDependableTrait = doesNotImplementDependableTrait;
const canOnlyEncodePositiveIntegers = () => new Error(`Can only encode positive integers into Tokens. This is a bug in CDKTF, please file a bug report.`);
exports.canOnlyEncodePositiveIntegers = canOnlyEncodePositiveIntegers;
const indexTooLargeToEncode = (index) => new Error(`Received an index too large to encode into a Token :${index}.

    This happens if you have too many Tokens in a single CDKTF application. This can also occur if you are accidentally creating numeric tokens in an infinite loop. For example, calling 'Token.asNumber()' too many times.

    If you reach the maximum number of allowed Tokens (a limitation imposed by the way we encode Tokens and separate them from real numeric values) you can work around this issue by dividing a single application into multiple applications.`);
exports.indexTooLargeToEncode = indexTooLargeToEncode;
const argToIntrinsicMustBePlainValue = (value, creationStack) => new Error(`You can only use a plain value (not a function) while creating an Intrinsic token. We received the value '${value}' created at:\n${creationStack.join("\n")}. If you want to use a function, please use the Lazy class. For example:  Lazy.anyValue({ produce: () => "Hello World" }).`);
exports.argToIntrinsicMustBePlainValue = argToIntrinsicMustBePlainValue;
const intrinsicNewError = (message, createdAt) => new Error(`${message}\nToken created:\n    at ${createdAt}\nError thrown:`);
exports.intrinsicNewError = intrinsicNewError;
const unableToResolveCircularReference = (pathName) => new Error(`Unable to resolve object tree with circular reference at '${pathName}'.

The depth of your object tree is over 200, indicating you probably have a cyclical reference. Inspect the construct creating this cyclic reference (most likely in '${pathName}') and ensure it does not infinitely nest constructs.`);
exports.unableToResolveCircularReference = unableToResolveCircularReference;
const cannotResolveFunction = (pathName, obj) => new Error(`Trying to resolve a non-data object (e.g., a function) at '${pathName}': ${obj}. Only tokens are supported for lazy evaluation.

If you want to use a lazily computed value, use the Lazy class. For example:  Lazy.stringValue({ produce: () => "Hello World" })`);
exports.cannotResolveFunction = cannotResolveFunction;
const LIST_ERROR_EXPLANATION = `In CDKTF, we represent lists, with values unknown until after runtime, as arrays with a single element— a string token (["Token.1"]).


We do this because CDKTF does not know the length of the list at compile time, meaning CDKTF has yet to invoke Terraform to communicate with the cloud provider. CDKTF later invokes Terraform on the synthesized static JSON file.

Because we don't know the length of the list, we can not differentiate if the list was accessed at the first or last index, or as part of a loop. To avoid this ambiguity:

- If you want to access a singular item, use 'Fn.element(list, 0)'. Do not use 'list[0]'.
- If you want to loop over the list use 'TerraformIterator.fromList(list)'. Do not use a 'for' or 'forEach' loop.

Learn more about tokens: https://developer.hashicorp.com/terraform/cdktf/concepts/tokens
Learn more about iterators: https://developer.hashicorp.com/terraform/cdktf/concepts/iterators`;
const MAP_ERROR_EXPLANATION = `
In CDKTF, we represent maps, with values unknown until after runtime, as objects with a single key-value pair where the value is a string token. For example: '{ "&{TfToken[Token.1]}": "String Map Token Value" }'.

We do this because CDKTF does not know the length of the list at compile time, meaning CDKTF has yet to invoke Terraform to communicate with the cloud provider. CDKTF later invokes Terraform on the synthesized static JSON file.

Because we don't know the contents of the map, we can not differentiate if the map was accessed, or used as part of a loop. To avoid this ambiguity:

- To access a singular item use 'Fn.lookup(map, key)'. Do not use 'map[key]'.
- If you want to loop over the map use 'TerraformIterator.fromMap(map)'. Do not use a 'for' loop or iterate over 'Object.entries(map)' with 'forEach'.

Learn more about tokens: https://developer.hashicorp.com/terraform/cdktf/concepts/tokens
Learn more about iterators: https://developer.hashicorp.com/terraform/cdktf/concepts/iterators`;
const encodedListTokenInScalarStringContext = () => new Error(`Found an encoded list token string in a scalar string context.
${LIST_ERROR_EXPLANATION}`);
exports.encodedListTokenInScalarStringContext = encodedListTokenInScalarStringContext;
const encodedMapTokenInScalarStringContext = () => new Error(`Found an encoded map token in a scalar string context.
${MAP_ERROR_EXPLANATION}`);
exports.encodedMapTokenInScalarStringContext = encodedMapTokenInScalarStringContext;
const encodedMapTokenInScalarNumberContext = () => new Error(`Found an encoded map token in a scalar number context.
${MAP_ERROR_EXPLANATION}`);
exports.encodedMapTokenInScalarNumberContext = encodedMapTokenInScalarNumberContext;
const constructsCannotBeResolved = (pathName) => new Error(`Trying to 'resolve()' a Construct at '${pathName}'.

This often means an unintended cyclic dependency in your construct tree, leading to the resolution stuck in an infinite loop that fails.
This can happen if the scope passed into this construct is also part of its subtree.

To resolve this issue, refactor your code to avoid this cyclic dependency by changing the scope of this construct.`);
exports.constructsCannotBeResolved = constructsCannotBeResolved;
const mapKeyMustResolveToString = (pathName, key, resolvedKey) => new Error(`At "${pathName}" a map uses the key "${key}", meaning that key must resolve to a string. However, it resolves to a ${typeof resolvedKey} with the value ${JSON.stringify(resolvedKey)}. To fix this, change the Token to resolve to a string.`);
exports.mapKeyMustResolveToString = mapKeyMustResolveToString;
const unknownTokenExplanation = `This means you are trying to access a Token value that does not exist. This can only happen if the Token is from another CDK (i.e., AWS CDK, CDK8s, etc.) and is unknown to this CDKTF Application. You either need to make the other CDK resolve this Token before CDKTF tries to resolve it, or work around using this Token at all.

If this error occurs without another CDK (or a value looking like a Token) involved, please file a bug.`;
const unknownNumberTokenFound = () => new Error(`Encoded representation of unknown number Token found. ${unknownTokenExplanation}`);
exports.unknownNumberTokenFound = unknownNumberTokenFound;
const unrecognizedTokenKey = (key) => new Error(`Unrecognized Token Key '${key}'. ${unknownTokenExplanation}`);
exports.unrecognizedTokenKey = unrecognizedTokenKey;
const IdIncludesUnresolvedTokens = (unresolvedTokens) => new Error(`This construct (or its parent construct) is configured with an ID that contains a Token: ${unresolvedTokens}. This is not allowed because IDs must be known statically during synthesis. Token values are only known during the apply stage, therefore they cannot be used in IDs. Please use a concrete value for your constructs ID instead.`);
exports.IdIncludesUnresolvedTokens = IdIncludesUnresolvedTokens;
const assetCanNotCreateZipArchive = (src, dest, error) => new Error(`A TerraformAsset trying to zip archive '${src}' into ${dest} failed: ${error}`);
exports.assetCanNotCreateZipArchive = assetCanNotCreateZipArchive;
const terraformModuleHasChildren = (pathName) => {
    return new Error(`Trying to add children to a TerraformModule at '${pathName}'. TerraformModules cannot have children, if you want to group resources or constructs in general together please use the Constructs class instead. See https://cdk.tf/constructs for more details.`);
};
exports.terraformModuleHasChildren = terraformModuleHasChildren;
//# sourceMappingURL=data:application/json;base64,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