/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { IDependable } from "constructs";
import { TerraformStack } from "./terraform-stack";
export declare const noAppFound: (constructPath: string) => Error;
export declare const appValidationFailure: (errorList: string) => Error;
export declare const providerVersionMismatch: () => Error;
export declare const assetOutOfScopeOfCDKTFJson: (id: string, configPath: string) => Error;
export declare const assetExpectsDirectory: (id: string, configPath: string) => Error;
export declare const assetTypeNotImplemented: () => Error;
export declare const dynamicBlockNotSupported: (_foreachExpression: string) => Error;
export declare const unresolvedTokenInConstructId: (id: string) => Error;
export declare const iteratorOnResourceWithCount: () => Error;
export declare const iteratorOnResourceWithoutForEach: () => Error;
export declare const modulesWithSameAlias: (alias: string) => Error;
export declare const moveTargetAlreadySet: (target: string, friendlyUniqueId: string | undefined) => Error;
export declare const moveTargetNotSet: (target: string, entries: string) => Error;
export declare const movedToResourceOfDifferentType: (moveTarget: string, originalResourceType: string, destinationResourceType: string) => Error;
export declare const resourceGivenTwoMoveOperationsByTargetAndId: (id: string, existingTarget: string, newMove: {
    to: string;
    from: string;
}) => Error;
export declare const resourceGivenTwoMoveOperationsById: (id: string, existingMove: {
    to: string;
    from: string;
}, newMove: {
    to: string;
    from: string;
}) => Error;
export declare const resourceGivenTwoMoveOperationsByTarget: (resourceId: string, existingMoveTarget: string, newMoveTarget: string) => Error;
export declare const stackContainsDisallowedChar: (stackId: string, invalidChar: string) => Error;
export declare const stackIdContainsWhitespace: (stackId: string) => Error;
export declare const noStackForConstruct: (constructPath: string, hint: string) => Error;
export declare const stackHasCircularDependency: (thisStack: TerraformStack, dependency: TerraformStack) => Error;
export declare const stackValidationFailure: (errorList: string) => Error;
export declare const matchersPathIsNotDirectory: (functionName: string) => Error;
export declare const matchersFoundErrorsInStack: (errorCount: any, stackName: string, diagnostics: string) => Error;
export declare const jestNotInstantiated: () => Error;
export declare const expectNotGloballyAccessible: () => Error;
export declare const invalidStack: (functionName: string, stackContent: string) => Error;
export declare const targetNotResolvableWithOverrides: (target: string) => Error;
export declare const sourceOrTargetNotAnObject: (source: string, sourceType: string, target: string, targetType: string) => Error;
export declare const constructDependencyBelowV10: () => Error;
export declare const cloudBackendWorkspaceIsNotDefinedByName: () => Error;
export declare const valueContainsUnescapedQuotes: (value: string) => Error;
export declare const encounteredAnnotationWithLevelError: (errors: string) => Error;
export declare const valueIsInvalidStringOrToken: (value: string) => Error;
export declare const valueIsInvalidNumberOrToken: (value: string) => Error;
export declare const listElementIsOfWrongType: (value: any[], position: number, error: unknown) => Error;
export declare const functionReceivedWrongNumberOfArgs: (name: string, argValidatorsLength: number, argsLength: number) => Error;
export declare const functionArgumentValidationFailure: (argNumber: number, name: string, error: unknown) => Error;
export declare const cannotCalcIdForEmptySetOfComponents: () => Error;
export declare const stringValueAddedToReferenceList: (listToken: string[]) => Error;
export declare const cannotConcatenateStringsInTokenizedStringArray: (listToken: string) => Error;
export declare const numberValueAddedToReferenceList: (listToken: number[]) => Error;
export declare const mapValueAddedToReferenceList: (mapToken: string) => Error;
export declare const cannotConcatenateStringsInTokenizedMap: (tokenizedMap: any) => Error;
export declare const doesNotImplementDependableTrait: (instance: IDependable) => Error;
export declare const canOnlyEncodePositiveIntegers: () => Error;
export declare const indexTooLargeToEncode: (index: number) => Error;
export declare const argToIntrinsicMustBePlainValue: (value: any, creationStack: string[]) => Error;
export declare const intrinsicNewError: (message: string, createdAt: string) => Error;
export declare const unableToResolveCircularReference: (pathName: string) => Error;
export declare const cannotResolveFunction: (pathName: string, obj: any) => Error;
export declare const encodedListTokenInScalarStringContext: () => Error;
export declare const encodedMapTokenInScalarStringContext: () => Error;
export declare const encodedMapTokenInScalarNumberContext: () => Error;
export declare const constructsCannotBeResolved: (pathName: string) => Error;
export declare const mapKeyMustResolveToString: (pathName: string, key: string, resolvedKey: any) => Error;
export declare const unknownNumberTokenFound: () => Error;
export declare const unrecognizedTokenKey: (key: string) => Error;
export declare const IdIncludesUnresolvedTokens: (unresolvedTokens: string) => Error;
export declare const assetCanNotCreateZipArchive: (src: string, dest: string, error: Error) => Error;
export declare const terraformModuleHasChildren: (pathName: string) => Error;
