"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnyListMap = exports.BooleanListMap = exports.NumberListMap = exports.StringListMap = exports.AnyMapList = exports.BooleanMapList = exports.NumberMapList = exports.StringMapList = exports.MapList = exports.ComplexObject = exports.ComplexMap = exports.AnyListList = exports.BooleanListList = exports.NumberListList = exports.StringListList = exports.BooleanList = exports.ComplexList = exports.ComplexComputedList = exports.AnyMap = exports.BooleanMap = exports.NumberMap = exports.StringMap = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const tokens_1 = require("./tokens");
const _1 = require(".");
const stack_trace_1 = require("./tokens/private/stack-trace");
const errors_1 = require("./errors");
// eslint-disable-next-line jsdoc/require-jsdoc
class ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.creationStack = (0, stack_trace_1.captureStackTrace)();
    }
    get fqn() {
        if (!this._fqn) {
            this._fqn = this.computeFqn();
        }
        return this._fqn;
    }
    resolve(_context) {
        return this.fqn;
    }
    toString() {
        return tokens_1.Token.asString(this);
    }
}
// eslint-disable-next-line jsdoc/require-jsdoc
class ComplexComputedAttribute extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    getStringAttribute(terraformAttribute) {
        return tokens_1.Token.asString(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberAttribute(terraformAttribute) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(terraformAttribute));
    }
    getListAttribute(terraformAttribute) {
        return tokens_1.Token.asList(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanAttribute(terraformAttribute) {
        return this.interpolationForAttribute(terraformAttribute);
    }
    getNumberListAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberList(this.interpolationForAttribute(terraformAttribute));
    }
    getStringMapAttribute(terraformAttribute) {
        return tokens_1.Token.asStringMap(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberMapAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberMap(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanMapAttribute(terraformAttribute) {
        return tokens_1.Token.asBooleanMap(this.interpolationForAttribute(terraformAttribute));
    }
    getAnyMapAttribute(terraformAttribute) {
        return tokens_1.Token.asAnyMap(this.interpolationForAttribute(terraformAttribute));
    }
}
// eslint-disable-next-line jsdoc/require-jsdoc
class StringMap extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    lookup(key) {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`));
    }
    computeFqn() {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
    }
}
exports.StringMap = StringMap;
_a = JSII_RTTI_SYMBOL_1;
StringMap[_a] = { fqn: "cdktf.StringMap", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class NumberMap extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    lookup(key) {
        return tokens_1.Token.asNumber(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`));
    }
    computeFqn() {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
    }
}
exports.NumberMap = NumberMap;
_b = JSII_RTTI_SYMBOL_1;
NumberMap[_b] = { fqn: "cdktf.NumberMap", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class BooleanMap extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    lookup(key) {
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`);
    }
    computeFqn() {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
    }
}
exports.BooleanMap = BooleanMap;
_c = JSII_RTTI_SYMBOL_1;
BooleanMap[_c] = { fqn: "cdktf.BooleanMap", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class AnyMap extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    lookup(key) {
        return tokens_1.Token.asAny(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`));
    }
    computeFqn() {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
    }
}
exports.AnyMap = AnyMap;
_d = JSII_RTTI_SYMBOL_1;
AnyMap[_d] = { fqn: "cdktf.AnyMap", version: "0.21.0" };
/**
 * @deprecated Going to be replaced by Array of ComplexListItem
 * and will be removed in the future
 */
class ComplexComputedList extends ComplexComputedAttribute {
    constructor(terraformResource, terraformAttribute, complexComputedListIndex, wrapsSet) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.complexComputedListIndex = complexComputedListIndex;
        this.wrapsSet = wrapsSet;
        throw (0, errors_1.providerVersionMismatch)();
    }
    interpolationForAttribute(property) {
        if (this.wrapsSet) {
            return (0, _1.propertyAccess)(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)), [this.complexComputedListIndex, property]);
        }
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${this.complexComputedListIndex}].${property}`);
    }
    computeFqn() {
        if (this.wrapsSet) {
            return tokens_1.Token.asString((0, _1.propertyAccess)(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)), [this.complexComputedListIndex]));
        }
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${this.complexComputedListIndex}]`));
    }
}
exports.ComplexComputedList = ComplexComputedList;
_e = JSII_RTTI_SYMBOL_1;
ComplexComputedList[_e] = { fqn: "cdktf.ComplexComputedList", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class ComplexList extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    computeFqn() {
        if (this.wrapsSet) {
            return tokens_1.Token.asString(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)));
        }
        else {
            return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
        }
    }
    /**
     * Creating an iterator for this complex list.
     * The list will be converted into a map with the mapKeyAttributeName as the key.
     * @param mapKeyAttributeName
     * @returns
     */
    allWithMapKey(mapKeyAttributeName) {
        return _1.TerraformIterator.fromComplexList(tokens_1.Token.asAny(this.computeFqn()), mapKeyAttributeName);
    }
}
exports.ComplexList = ComplexList;
_f = JSII_RTTI_SYMBOL_1;
ComplexList[_f] = { fqn: "cdktf.ComplexList", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class BooleanList extends ComplexList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        return _1.Fn.element(this, index);
    }
}
exports.BooleanList = BooleanList;
_g = JSII_RTTI_SYMBOL_1;
BooleanList[_g] = { fqn: "cdktf.BooleanList", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class StringListList extends ComplexList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        return tokens_1.Token.asList(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${index}]`));
    }
}
exports.StringListList = StringListList;
_h = JSII_RTTI_SYMBOL_1;
StringListList[_h] = { fqn: "cdktf.StringListList", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class NumberListList extends ComplexList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        return tokens_1.Token.asNumberList(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${index}]`));
    }
}
exports.NumberListList = NumberListList;
_j = JSII_RTTI_SYMBOL_1;
NumberListList[_j] = { fqn: "cdktf.NumberListList", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class BooleanListList extends ComplexList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        // This isn't fully supported
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${index}]`);
    }
}
exports.BooleanListList = BooleanListList;
_k = JSII_RTTI_SYMBOL_1;
BooleanListList[_k] = { fqn: "cdktf.BooleanListList", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class AnyListList extends ComplexList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        // This isn't fully supported
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${index}]`);
    }
}
exports.AnyListList = AnyListList;
_l = JSII_RTTI_SYMBOL_1;
AnyListList[_l] = { fqn: "cdktf.AnyListList", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class ComplexMap extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    computeFqn() {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
    }
    interpolationForAttribute(property) {
        return (0, _1.propertyAccess)(this.terraformResource.interpolationForAttribute(this.terraformAttribute), [property]);
    }
}
exports.ComplexMap = ComplexMap;
_m = JSII_RTTI_SYMBOL_1;
ComplexMap[_m] = { fqn: "cdktf.ComplexMap", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class ComplexObject extends ComplexComputedAttribute {
    /**
     * @param terraformResource
     * @param terraformAttribute
     * @param complexObjectIndex the index of the complex object in a list
     * @param complexObjectIsFromSet set to true if this item is from inside a set and needs tolist() for accessing it
     *                               set to "0" for single list items
     */
    constructor(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.complexObjectIsFromSet = complexObjectIsFromSet;
        this.complexObjectIndex = complexObjectIndex;
    }
    interpolationForAttribute(property) {
        if (this.complexObjectIsFromSet) {
            return (0, _1.propertyAccess)(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)), [this.complexObjectIndex, property]);
        }
        return this.terraformResource.interpolationForAttribute(this.complexObjectIndex !== undefined
            ? `${this.terraformAttribute}[${this.complexObjectIndex}].${property}`
            : `${this.terraformAttribute}.${property}`);
    }
    interpolationAsList() {
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}.*`);
    }
    computeFqn() {
        if (this.complexObjectIsFromSet) {
            return tokens_1.Token.asString((0, _1.propertyAccess)(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)), [this.complexObjectIndex]));
        }
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.complexObjectIndex !== undefined
            ? `${this.terraformAttribute}[${this.complexObjectIndex}]`
            : this.terraformAttribute));
    }
}
exports.ComplexObject = ComplexObject;
_o = JSII_RTTI_SYMBOL_1;
ComplexObject[_o] = { fqn: "cdktf.ComplexObject", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class MapList extends ComplexResolvable {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    computeFqn() {
        if (this.wrapsSet) {
            return tokens_1.Token.asString(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)));
        }
        else {
            return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(this.terraformAttribute));
        }
    }
    interpolationForAttribute(property) {
        if (this.wrapsSet) {
            const matches = property.match(/\[([^\]]*)\]/); // need to extract out the index
            if (matches) {
                return (0, _1.propertyAccess)(_1.Fn.tolist(this.terraformResource.interpolationForAttribute(this.terraformAttribute)), [matches[1], property]);
            }
        }
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}${property}`);
    }
}
exports.MapList = MapList;
_p = JSII_RTTI_SYMBOL_1;
MapList[_p] = { fqn: "cdktf.MapList", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class StringMapList extends MapList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        return new StringMap(this, `[${index}]`);
    }
}
exports.StringMapList = StringMapList;
_q = JSII_RTTI_SYMBOL_1;
StringMapList[_q] = { fqn: "cdktf.StringMapList", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class NumberMapList extends MapList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        return new NumberMap(this, `[${index}]`);
    }
}
exports.NumberMapList = NumberMapList;
_r = JSII_RTTI_SYMBOL_1;
NumberMapList[_r] = { fqn: "cdktf.NumberMapList", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class BooleanMapList extends MapList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        return new BooleanMap(this, `[${index}]`);
    }
}
exports.BooleanMapList = BooleanMapList;
_s = JSII_RTTI_SYMBOL_1;
BooleanMapList[_s] = { fqn: "cdktf.BooleanMapList", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class AnyMapList extends MapList {
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    get(index) {
        return new AnyMap(this, `[${index}]`);
    }
}
exports.AnyMapList = AnyMapList;
_t = JSII_RTTI_SYMBOL_1;
AnyMapList[_t] = { fqn: "cdktf.AnyMapList", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class StringListMap extends ComplexMap {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    get(key) {
        return tokens_1.Token.asList(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${key}]`));
    }
}
exports.StringListMap = StringListMap;
_u = JSII_RTTI_SYMBOL_1;
StringListMap[_u] = { fqn: "cdktf.StringListMap", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class NumberListMap extends ComplexMap {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    get(key) {
        return tokens_1.Token.asNumberList(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${key}]`));
    }
}
exports.NumberListMap = NumberListMap;
_v = JSII_RTTI_SYMBOL_1;
NumberListMap[_v] = { fqn: "cdktf.NumberListMap", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class BooleanListMap extends ComplexMap {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    get(key) {
        // This isn't fully supported
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${key}]`);
    }
}
exports.BooleanListMap = BooleanListMap;
_w = JSII_RTTI_SYMBOL_1;
BooleanListMap[_w] = { fqn: "cdktf.BooleanListMap", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class AnyListMap extends ComplexMap {
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    get(key) {
        // This isn't fully supported
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}[${key}]`);
    }
}
exports.AnyListMap = AnyListMap;
_x = JSII_RTTI_SYMBOL_1;
AnyListMap[_x] = { fqn: "cdktf.AnyListMap", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcGxleC1jb21wdXRlZC1saXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tcGxleC1jb21wdXRlZC1saXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0JBQStCO0FBQy9CLG1DQUFtQztBQUNuQyxxQ0FBK0Q7QUFLL0Qsd0JBS1c7QUFDWCw4REFBaUU7QUFDakUscUNBQW1EO0FBRW5ELCtDQUErQztBQUMvQyxNQUFlLGlCQUFpQjtJQVE5QixZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEI7UUFEMUIsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7UUFFcEMsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFBLCtCQUFpQixHQUFFLENBQUM7SUFDM0MsQ0FBQztJQUlELElBQUksR0FBRztRQUNMLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7WUFDZixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQztRQUNoQyxDQUFDO1FBRUQsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDO0lBQ25CLENBQUM7SUFFRCxPQUFPLENBQUMsUUFBeUI7UUFDL0IsT0FBTyxJQUFJLENBQUMsR0FBRyxDQUFDO0lBQ2xCLENBQUM7SUFFRCxRQUFRO1FBQ04sT0FBTyxjQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQzlCLENBQUM7Q0FDRjtBQUVELCtDQUErQztBQUMvQyxNQUFlLHdCQUNiLFNBQVEsaUJBQWlCO0lBR3pCLFlBQ1ksaUJBQXVDLEVBQ3ZDLGtCQUEwQjtRQUVwQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQUhuQyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtJQUd0QyxDQUFDO0lBRU0sa0JBQWtCLENBQUMsa0JBQTBCO1FBQ2xELE9BQU8sY0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMseUJBQXlCLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDO0lBQzVFLENBQUM7SUFFTSxrQkFBa0IsQ0FBQyxrQkFBMEI7UUFDbEQsT0FBTyxjQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDNUUsQ0FBQztJQUVNLGdCQUFnQixDQUFDLGtCQUEwQjtRQUNoRCxPQUFPLGNBQUssQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLHlCQUF5QixDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUMxRSxDQUFDO0lBRU0sbUJBQW1CLENBQUMsa0JBQTBCO1FBQ25ELE9BQU8sSUFBSSxDQUFDLHlCQUF5QixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDNUQsQ0FBQztJQUVNLHNCQUFzQixDQUFDLGtCQUEwQjtRQUN0RCxPQUFPLGNBQUssQ0FBQyxZQUFZLENBQ3ZCLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxrQkFBa0IsQ0FBQyxDQUNuRCxDQUFDO0lBQ0osQ0FBQztJQUVNLHFCQUFxQixDQUFDLGtCQUEwQjtRQUNyRCxPQUFPLGNBQUssQ0FBQyxXQUFXLENBQ3RCLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxrQkFBa0IsQ0FBQyxDQUNuRCxDQUFDO0lBQ0osQ0FBQztJQUVNLHFCQUFxQixDQUFDLGtCQUEwQjtRQUNyRCxPQUFPLGNBQUssQ0FBQyxXQUFXLENBQ3RCLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxrQkFBa0IsQ0FBQyxDQUNuRCxDQUFDO0lBQ0osQ0FBQztJQUVNLHNCQUFzQixDQUFDLGtCQUEwQjtRQUN0RCxPQUFPLGNBQUssQ0FBQyxZQUFZLENBQ3ZCLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxrQkFBa0IsQ0FBQyxDQUNuRCxDQUFDO0lBQ0osQ0FBQztJQUVNLGtCQUFrQixDQUFDLGtCQUEwQjtRQUNsRCxPQUFPLGNBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLHlCQUF5QixDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUM1RSxDQUFDO0NBR0Y7QUFFRCwrQ0FBK0M7QUFDL0MsTUFBYSxTQUNYLFNBQVEsaUJBQWlCO0lBR3pCLFlBQ1ksaUJBQXVDLEVBQ3ZDLGtCQUEwQjtRQUVwQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQUhuQyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtJQUd0QyxDQUFDO0lBRU0sTUFBTSxDQUFDLEdBQVc7UUFDdkIsT0FBTyxjQUFLLENBQUMsUUFBUSxDQUNuQixJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQzlDLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixLQUFLLEdBQUcsSUFBSSxDQUN2QyxDQUNGLENBQUM7SUFDSixDQUFDO0lBRUQsVUFBVTtRQUNSLE9BQU8sY0FBSyxDQUFDLFFBQVEsQ0FDbkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxDQUMxRSxDQUFDO0lBQ0osQ0FBQzs7QUF2QkgsOEJBd0JDOzs7QUFFRCwrQ0FBK0M7QUFDL0MsTUFBYSxTQUNYLFNBQVEsaUJBQWlCO0lBR3pCLFlBQ1ksaUJBQXVDLEVBQ3ZDLGtCQUEwQjtRQUVwQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQUhuQyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtJQUd0QyxDQUFDO0lBRU0sTUFBTSxDQUFDLEdBQVc7UUFDdkIsT0FBTyxjQUFLLENBQUMsUUFBUSxDQUNuQixJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQzlDLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixLQUFLLEdBQUcsSUFBSSxDQUN2QyxDQUNGLENBQUM7SUFDSixDQUFDO0lBRUQsVUFBVTtRQUNSLE9BQU8sY0FBSyxDQUFDLFFBQVEsQ0FDbkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxDQUMxRSxDQUFDO0lBQ0osQ0FBQzs7QUF2QkgsOEJBd0JDOzs7QUFFRCwrQ0FBK0M7QUFDL0MsTUFBYSxVQUNYLFNBQVEsaUJBQWlCO0lBR3pCLFlBQ1ksaUJBQXVDLEVBQ3ZDLGtCQUEwQjtRQUVwQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQUhuQyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtJQUd0QyxDQUFDO0lBRU0sTUFBTSxDQUFDLEdBQVc7UUFDdkIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQ3JELEdBQUcsSUFBSSxDQUFDLGtCQUFrQixLQUFLLEdBQUcsSUFBSSxDQUN2QyxDQUFDO0lBQ0osQ0FBQztJQUVELFVBQVU7UUFDUixPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FDMUUsQ0FBQztJQUNKLENBQUM7O0FBckJILGdDQXNCQzs7O0FBRUQsK0NBQStDO0FBQy9DLE1BQWEsTUFBTyxTQUFRLGlCQUFpQjtJQUMzQyxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEI7UUFFcEMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFIbkMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7SUFHdEMsQ0FBQztJQUVNLE1BQU0sQ0FBQyxHQUFXO1FBQ3ZCLE9BQU8sY0FBSyxDQUFDLEtBQUssQ0FDaEIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsS0FBSyxHQUFHLElBQUksQ0FDdkMsQ0FDRixDQUFDO0lBQ0osQ0FBQztJQUVELFVBQVU7UUFDUixPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FDMUUsQ0FBQztJQUNKLENBQUM7O0FBcEJILHdCQXFCQzs7O0FBRUQ7OztHQUdHO0FBQ0gsTUFBYSxtQkFBb0IsU0FBUSx3QkFBd0I7SUFDL0QsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCLEVBQzFCLHdCQUFnQyxFQUNoQyxRQUFrQjtRQUU1QixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQUxuQyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtRQUMxQiw2QkFBd0IsR0FBeEIsd0JBQXdCLENBQVE7UUFDaEMsYUFBUSxHQUFSLFFBQVEsQ0FBVTtRQUc1QixNQUFNLElBQUEsZ0NBQXVCLEdBQUUsQ0FBQztJQUNsQyxDQUFDO0lBRU0seUJBQXlCLENBQUMsUUFBZ0I7UUFDL0MsSUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7WUFDbEIsT0FBTyxJQUFBLGlCQUFjLEVBQ25CLEtBQUUsQ0FBQyxNQUFNLENBQ1AsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxJQUFJLENBQUMsa0JBQWtCLENBQ3hCLENBQ0YsRUFDRCxDQUFDLElBQUksQ0FBQyx3QkFBd0IsRUFBRSxRQUFRLENBQUMsQ0FDMUMsQ0FBQztRQUNKLENBQUM7UUFFRCxPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDckQsR0FBRyxJQUFJLENBQUMsa0JBQWtCLElBQUksSUFBSSxDQUFDLHdCQUF3QixLQUFLLFFBQVEsRUFBRSxDQUMzRSxDQUFDO0lBQ0osQ0FBQztJQUVELFVBQVU7UUFDUixJQUFJLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQztZQUNsQixPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLElBQUEsaUJBQWMsRUFDWixLQUFFLENBQUMsTUFBTSxDQUNQLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsSUFBSSxDQUFDLGtCQUFrQixDQUN4QixDQUNGLEVBQ0QsQ0FBQyxJQUFJLENBQUMsd0JBQXdCLENBQUMsQ0FDaEMsQ0FDRixDQUFDO1FBQ0osQ0FBQztRQUVELE9BQU8sY0FBSyxDQUFDLFFBQVEsQ0FDbkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxJQUFJLENBQUMsd0JBQXdCLEdBQUcsQ0FDL0QsQ0FDRixDQUFDO0lBQ0osQ0FBQzs7QUEvQ0gsa0RBZ0RDOzs7QUFFRCwrQ0FBK0M7QUFDL0MsTUFBc0IsV0FDcEIsU0FBUSxpQkFBaUI7SUFHekIsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCLEVBQzFCLFFBQWlCO1FBRTNCLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBSm5DLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO1FBQzFCLGFBQVEsR0FBUixRQUFRLENBQVM7SUFHN0IsQ0FBQztJQUVELFVBQVU7UUFDUixJQUFJLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQztZQUNsQixPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLEtBQUUsQ0FBQyxNQUFNLENBQ1AsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxJQUFJLENBQUMsa0JBQWtCLENBQ3hCLENBQ0YsQ0FDRixDQUFDO1FBQ0osQ0FBQzthQUFNLENBQUM7WUFDTixPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsSUFBSSxDQUFDLGtCQUFrQixDQUN4QixDQUNGLENBQUM7UUFDSixDQUFDO0lBQ0gsQ0FBQztJQUVEOzs7OztPQUtHO0lBQ0ksYUFBYSxDQUNsQixtQkFBMkI7UUFFM0IsT0FBTyxvQkFBaUIsQ0FBQyxlQUFlLENBQ3RDLGNBQUssQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDLEVBQzlCLG1CQUFtQixDQUNwQixDQUFDO0lBQ0osQ0FBQzs7QUEzQ0gsa0NBNENDOzs7QUFFRCwrQ0FBK0M7QUFDL0MsTUFBYSxXQUFZLFNBQVEsV0FBVztJQUMxQyxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEIsRUFDMUIsUUFBaUI7UUFFM0IsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBSjdDLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO1FBQzFCLGFBQVEsR0FBUixRQUFRLENBQVM7SUFHN0IsQ0FBQztJQUVNLEdBQUcsQ0FBQyxLQUFhO1FBQ3RCLE9BQU8sS0FBRSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDakMsQ0FBQzs7QUFYSCxrQ0FZQzs7O0FBRUQsK0NBQStDO0FBQy9DLE1BQWEsY0FBZSxTQUFRLFdBQVc7SUFDN0MsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCLEVBQzFCLFFBQWlCO1FBRTNCLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUo3QyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtRQUMxQixhQUFRLEdBQVIsUUFBUSxDQUFTO0lBRzdCLENBQUM7SUFFTSxHQUFHLENBQUMsS0FBYTtRQUN0QixPQUFPLGNBQUssQ0FBQyxNQUFNLENBQ2pCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsR0FBRyxJQUFJLENBQUMsa0JBQWtCLElBQUksS0FBSyxHQUFHLENBQ3ZDLENBQ0YsQ0FBQztJQUNKLENBQUM7O0FBZkgsd0NBZ0JDOzs7QUFFRCwrQ0FBK0M7QUFDL0MsTUFBYSxjQUFlLFNBQVEsV0FBVztJQUM3QyxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEIsRUFDMUIsUUFBaUI7UUFFM0IsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBSjdDLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO1FBQzFCLGFBQVEsR0FBUixRQUFRLENBQVM7SUFHN0IsQ0FBQztJQUVNLEdBQUcsQ0FBQyxLQUFhO1FBQ3RCLE9BQU8sY0FBSyxDQUFDLFlBQVksQ0FDdkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxLQUFLLEdBQUcsQ0FDdkMsQ0FDRixDQUFDO0lBQ0osQ0FBQzs7QUFmSCx3Q0FnQkM7OztBQUVELCtDQUErQztBQUMvQyxNQUFhLGVBQWdCLFNBQVEsV0FBVztJQUM5QyxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEIsRUFDMUIsUUFBaUI7UUFFM0IsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBSjdDLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO1FBQzFCLGFBQVEsR0FBUixRQUFRLENBQVM7SUFHN0IsQ0FBQztJQUVNLEdBQUcsQ0FBQyxLQUFhO1FBQ3RCLDZCQUE2QjtRQUM3QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDckQsR0FBRyxJQUFJLENBQUMsa0JBQWtCLElBQUksS0FBSyxHQUFHLENBQ3ZDLENBQUM7SUFDSixDQUFDOztBQWRILDBDQWVDOzs7QUFFRCwrQ0FBK0M7QUFDL0MsTUFBYSxXQUFZLFNBQVEsV0FBVztJQUMxQyxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEIsRUFDMUIsUUFBaUI7UUFFM0IsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBSjdDLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO1FBQzFCLGFBQVEsR0FBUixRQUFRLENBQVM7SUFHN0IsQ0FBQztJQUVNLEdBQUcsQ0FBQyxLQUFhO1FBQ3RCLDZCQUE2QjtRQUM3QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDckQsR0FBRyxJQUFJLENBQUMsa0JBQWtCLElBQUksS0FBSyxHQUFHLENBQ3ZDLENBQUM7SUFDSixDQUFDOztBQWRILGtDQWVDOzs7QUFFRCwrQ0FBK0M7QUFDL0MsTUFBc0IsVUFDcEIsU0FBUSxpQkFBaUI7SUFHekIsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCO1FBRXBDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBSG5DLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO0lBR3RDLENBQUM7SUFFRCxVQUFVO1FBQ1IsT0FBTyxjQUFLLENBQUMsUUFBUSxDQUNuQixJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLENBQzFFLENBQUM7SUFDSixDQUFDO0lBRUQseUJBQXlCLENBQUMsUUFBZ0I7UUFDeEMsT0FBTyxJQUFBLGlCQUFjLEVBQ25CLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsRUFDekUsQ0FBQyxRQUFRLENBQUMsQ0FDWCxDQUFDO0lBQ0osQ0FBQzs7QUF0QkgsZ0NBdUJDOzs7QUFFRCwrQ0FBK0M7QUFDL0MsTUFBYSxhQUFjLFNBQVEsd0JBQXdCO0lBQ3pEOzs7Ozs7T0FNRztJQUNILFlBQ1ksaUJBQXVDLEVBQ3ZDLGtCQUEwQixFQUMxQixzQkFBK0IsRUFDL0Isa0JBQW9DO1FBRTlDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBTG5DLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO1FBQzFCLDJCQUFzQixHQUF0QixzQkFBc0IsQ0FBUztRQUMvQix1QkFBa0IsR0FBbEIsa0JBQWtCLENBQWtCO0lBR2hELENBQUM7SUFFTSx5QkFBeUIsQ0FBQyxRQUFnQjtRQUMvQyxJQUFJLElBQUksQ0FBQyxzQkFBc0IsRUFBRSxDQUFDO1lBQ2hDLE9BQU8sSUFBQSxpQkFBYyxFQUNuQixLQUFFLENBQUMsTUFBTSxDQUNQLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsSUFBSSxDQUFDLGtCQUFrQixDQUN4QixDQUNGLEVBQ0QsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLEVBQUUsUUFBUSxDQUFDLENBQ3BDLENBQUM7UUFDSixDQUFDO1FBRUQsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQ3JELElBQUksQ0FBQyxrQkFBa0IsS0FBSyxTQUFTO1lBQ25DLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxJQUFJLENBQUMsa0JBQWtCLEtBQUssUUFBUSxFQUFFO1lBQ3RFLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxRQUFRLEVBQUUsQ0FDN0MsQ0FBQztJQUNKLENBQUM7SUFFUyxtQkFBbUI7UUFDM0IsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQ3JELEdBQUcsSUFBSSxDQUFDLGtCQUFrQixJQUFJLENBQy9CLENBQUM7SUFDSixDQUFDO0lBRUQsVUFBVTtRQUNSLElBQUksSUFBSSxDQUFDLHNCQUFzQixFQUFFLENBQUM7WUFDaEMsT0FBTyxjQUFLLENBQUMsUUFBUSxDQUNuQixJQUFBLGlCQUFjLEVBQ1osS0FBRSxDQUFDLE1BQU0sQ0FDUCxJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQzlDLElBQUksQ0FBQyxrQkFBa0IsQ0FDeEIsQ0FDRixFQUNELENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLENBQzFCLENBQ0YsQ0FBQztRQUNKLENBQUM7UUFFRCxPQUFPLGNBQUssQ0FBQyxRQUFRLENBQ25CLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsSUFBSSxDQUFDLGtCQUFrQixLQUFLLFNBQVM7WUFDbkMsQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixJQUFJLElBQUksQ0FBQyxrQkFBa0IsR0FBRztZQUMxRCxDQUFDLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUM1QixDQUNGLENBQUM7SUFDSixDQUFDOztBQS9ESCxzQ0FnRUM7OztBQUVELCtDQUErQztBQUMvQyxNQUFzQixPQUNwQixTQUFRLGlCQUFpQjtJQUd6QixZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEIsRUFDMUIsUUFBaUI7UUFFM0IsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFKbkMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7UUFDMUIsYUFBUSxHQUFSLFFBQVEsQ0FBUztJQUc3QixDQUFDO0lBRUQsVUFBVTtRQUNSLElBQUksSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDO1lBQ2xCLE9BQU8sY0FBSyxDQUFDLFFBQVEsQ0FDbkIsS0FBRSxDQUFDLE1BQU0sQ0FDUCxJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQzlDLElBQUksQ0FBQyxrQkFBa0IsQ0FDeEIsQ0FDRixDQUNGLENBQUM7UUFDSixDQUFDO2FBQU0sQ0FBQztZQUNOLE9BQU8sY0FBSyxDQUFDLFFBQVEsQ0FDbkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUM5QyxJQUFJLENBQUMsa0JBQWtCLENBQ3hCLENBQ0YsQ0FBQztRQUNKLENBQUM7SUFDSCxDQUFDO0lBRUQseUJBQXlCLENBQUMsUUFBZ0I7UUFDeEMsSUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7WUFDbEIsTUFBTSxPQUFPLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLGdDQUFnQztZQUNoRixJQUFJLE9BQU8sRUFBRSxDQUFDO2dCQUNaLE9BQU8sSUFBQSxpQkFBYyxFQUNuQixLQUFFLENBQUMsTUFBTSxDQUNQLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsSUFBSSxDQUFDLGtCQUFrQixDQUN4QixDQUNGLEVBQ0QsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsUUFBUSxDQUFDLENBQ3ZCLENBQUM7WUFDSixDQUFDO1FBQ0gsQ0FBQztRQUVELE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixDQUNyRCxHQUFHLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxRQUFRLEVBQUUsQ0FDeEMsQ0FBQztJQUNKLENBQUM7O0FBaERILDBCQWlEQzs7O0FBRUQsK0NBQStDO0FBQy9DLE1BQWEsYUFBYyxTQUFRLE9BQU87SUFDeEMsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCLEVBQzFCLFFBQWlCO1FBRTNCLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUo3QyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtRQUMxQixhQUFRLEdBQVIsUUFBUSxDQUFTO0lBRzdCLENBQUM7SUFFTSxHQUFHLENBQUMsS0FBYTtRQUN0QixPQUFPLElBQUksU0FBUyxDQUFDLElBQUksRUFBRSxJQUFJLEtBQUssR0FBRyxDQUFDLENBQUM7SUFDM0MsQ0FBQzs7QUFYSCxzQ0FZQzs7O0FBRUQsK0NBQStDO0FBQy9DLE1BQWEsYUFBYyxTQUFRLE9BQU87SUFDeEMsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCLEVBQzFCLFFBQWlCO1FBRTNCLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUo3QyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtRQUMxQixhQUFRLEdBQVIsUUFBUSxDQUFTO0lBRzdCLENBQUM7SUFFTSxHQUFHLENBQUMsS0FBYTtRQUN0QixPQUFPLElBQUksU0FBUyxDQUFDLElBQUksRUFBRSxJQUFJLEtBQUssR0FBRyxDQUFDLENBQUM7SUFDM0MsQ0FBQzs7QUFYSCxzQ0FZQzs7O0FBRUQsK0NBQStDO0FBQy9DLE1BQWEsY0FBZSxTQUFRLE9BQU87SUFDekMsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCLEVBQzFCLFFBQWlCO1FBRTNCLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUo3QyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtRQUMxQixhQUFRLEdBQVIsUUFBUSxDQUFTO0lBRzdCLENBQUM7SUFFTSxHQUFHLENBQUMsS0FBYTtRQUN0QixPQUFPLElBQUksVUFBVSxDQUFDLElBQUksRUFBRSxJQUFJLEtBQUssR0FBRyxDQUFDLENBQUM7SUFDNUMsQ0FBQzs7QUFYSCx3Q0FZQzs7O0FBRUQsK0NBQStDO0FBQy9DLE1BQWEsVUFBVyxTQUFRLE9BQU87SUFDckMsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCLEVBQzFCLFFBQWlCO1FBRTNCLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUo3QyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtRQUMxQixhQUFRLEdBQVIsUUFBUSxDQUFTO0lBRzdCLENBQUM7SUFFTSxHQUFHLENBQUMsS0FBYTtRQUN0QixPQUFPLElBQUksTUFBTSxDQUFDLElBQUksRUFBRSxJQUFJLEtBQUssR0FBRyxDQUFDLENBQUM7SUFDeEMsQ0FBQzs7QUFYSCxnQ0FZQzs7O0FBRUQsK0NBQStDO0FBQy9DLE1BQWEsYUFBYyxTQUFRLFVBQVU7SUFDM0MsWUFDWSxpQkFBdUMsRUFDdkMsa0JBQTBCO1FBRXBDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBSG5DLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBc0I7UUFDdkMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFRO0lBR3RDLENBQUM7SUFFTSxHQUFHLENBQUMsR0FBVztRQUNwQixPQUFPLGNBQUssQ0FBQyxNQUFNLENBQ2pCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDOUMsR0FBRyxJQUFJLENBQUMsa0JBQWtCLElBQUksR0FBRyxHQUFHLENBQ3JDLENBQ0YsQ0FBQztJQUNKLENBQUM7O0FBZEgsc0NBZUM7OztBQUVELCtDQUErQztBQUMvQyxNQUFhLGFBQWMsU0FBUSxVQUFVO0lBQzNDLFlBQ1ksaUJBQXVDLEVBQ3ZDLGtCQUEwQjtRQUVwQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQUhuQyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO1FBQ3ZDLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtJQUd0QyxDQUFDO0lBRU0sR0FBRyxDQUFDLEdBQVc7UUFDcEIsT0FBTyxjQUFLLENBQUMsWUFBWSxDQUN2QixJQUFJLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLENBQzlDLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixJQUFJLEdBQUcsR0FBRyxDQUNyQyxDQUNGLENBQUM7SUFDSixDQUFDOztBQWRILHNDQWVDOzs7QUFFRCwrQ0FBK0M7QUFDL0MsTUFBYSxjQUFlLFNBQVEsVUFBVTtJQUM1QyxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEI7UUFFcEMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFIbkMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7SUFHdEMsQ0FBQztJQUVNLEdBQUcsQ0FBQyxHQUFXO1FBQ3BCLDZCQUE2QjtRQUM3QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDckQsR0FBRyxJQUFJLENBQUMsa0JBQWtCLElBQUksR0FBRyxHQUFHLENBQ3JDLENBQUM7SUFDSixDQUFDOztBQWJILHdDQWNDOzs7QUFFRCwrQ0FBK0M7QUFDL0MsTUFBYSxVQUFXLFNBQVEsVUFBVTtJQUN4QyxZQUNZLGlCQUF1QyxFQUN2QyxrQkFBMEI7UUFFcEMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFIbkMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFzQjtRQUN2Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7SUFHdEMsQ0FBQztJQUVNLEdBQUcsQ0FBQyxHQUFXO1FBQ3BCLDZCQUE2QjtRQUM3QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsQ0FDckQsR0FBRyxJQUFJLENBQUMsa0JBQWtCLElBQUksR0FBRyxHQUFHLENBQ3JDLENBQUM7SUFDSixDQUFDOztBQWJILGdDQWNDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluY1xuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1QTC0yLjBcbmltcG9ydCB7IElSZXNvbHZhYmxlLCBUb2tlbiwgSVJlc29sdmVDb250ZXh0IH0gZnJvbSBcIi4vdG9rZW5zXCI7XG5pbXBvcnQge1xuICBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgSVRlcnJhZm9ybUFkZHJlc3NhYmxlLFxufSBmcm9tIFwiLi90ZXJyYWZvcm0tYWRkcmVzc2FibGVcIjtcbmltcG9ydCB7XG4gIHByb3BlcnR5QWNjZXNzLFxuICBGbixcbiAgVGVycmFmb3JtSXRlcmF0b3IsXG4gIER5bmFtaWNMaXN0VGVycmFmb3JtSXRlcmF0b3IsXG59IGZyb20gXCIuXCI7XG5pbXBvcnQgeyBjYXB0dXJlU3RhY2tUcmFjZSB9IGZyb20gXCIuL3Rva2Vucy9wcml2YXRlL3N0YWNrLXRyYWNlXCI7XG5pbXBvcnQgeyBwcm92aWRlclZlcnNpb25NaXNtYXRjaCB9IGZyb20gXCIuL2Vycm9yc1wiO1xuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuYWJzdHJhY3QgY2xhc3MgQ29tcGxleFJlc29sdmFibGUgaW1wbGVtZW50cyBJUmVzb2x2YWJsZSwgSVRlcnJhZm9ybUFkZHJlc3NhYmxlIHtcbiAgcHVibGljIHJlYWRvbmx5IGNyZWF0aW9uU3RhY2s6IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHByb3RlY3RlZCBfZnFuPzogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLFxuICApIHtcbiAgICB0aGlzLmNyZWF0aW9uU3RhY2sgPSBjYXB0dXJlU3RhY2tUcmFjZSgpO1xuICB9XG5cbiAgYWJzdHJhY3QgY29tcHV0ZUZxbigpOiBzdHJpbmc7XG5cbiAgZ2V0IGZxbigpOiBzdHJpbmcge1xuICAgIGlmICghdGhpcy5fZnFuKSB7XG4gICAgICB0aGlzLl9mcW4gPSB0aGlzLmNvbXB1dGVGcW4oKTtcbiAgICB9XG5cbiAgICByZXR1cm4gdGhpcy5fZnFuO1xuICB9XG5cbiAgcmVzb2x2ZShfY29udGV4dDogSVJlc29sdmVDb250ZXh0KTogYW55IHtcbiAgICByZXR1cm4gdGhpcy5mcW47XG4gIH1cblxuICB0b1N0cmluZygpOiBzdHJpbmcge1xuICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyh0aGlzKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuYWJzdHJhY3QgY2xhc3MgQ29tcGxleENvbXB1dGVkQXR0cmlidXRlXG4gIGV4dGVuZHMgQ29tcGxleFJlc29sdmFibGVcbiAgaW1wbGVtZW50cyBJSW50ZXJwb2xhdGluZ1BhcmVudFxue1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZyxcbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0U3RyaW5nQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nKHRoaXMuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSh0ZXJyYWZvcm1BdHRyaWJ1dGUpKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXROdW1iZXJBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gVG9rZW4uYXNOdW1iZXIodGhpcy5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZSkpO1xuICB9XG5cbiAgcHVibGljIGdldExpc3RBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gVG9rZW4uYXNMaXN0KHRoaXMuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSh0ZXJyYWZvcm1BdHRyaWJ1dGUpKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXRCb29sZWFuQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKTogSVJlc29sdmFibGUge1xuICAgIHJldHVybiB0aGlzLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXROdW1iZXJMaXN0QXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgcmV0dXJuIFRva2VuLmFzTnVtYmVyTGlzdChcbiAgICAgIHRoaXMuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSh0ZXJyYWZvcm1BdHRyaWJ1dGUpLFxuICAgICk7XG4gIH1cblxuICBwdWJsaWMgZ2V0U3RyaW5nTWFwQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nTWFwKFxuICAgICAgdGhpcy5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZSksXG4gICAgKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXROdW1iZXJNYXBBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gVG9rZW4uYXNOdW1iZXJNYXAoXG4gICAgICB0aGlzLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlKSxcbiAgICApO1xuICB9XG5cbiAgcHVibGljIGdldEJvb2xlYW5NYXBBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gVG9rZW4uYXNCb29sZWFuTWFwKFxuICAgICAgdGhpcy5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZSksXG4gICAgKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXRBbnlNYXBBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gVG9rZW4uYXNBbnlNYXAodGhpcy5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHRlcnJhZm9ybUF0dHJpYnV0ZSkpO1xuICB9XG5cbiAgcHVibGljIGFic3RyYWN0IGludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUodGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpOiBhbnk7XG59XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgY2xhc3MgU3RyaW5nTWFwXG4gIGV4dGVuZHMgQ29tcGxleFJlc29sdmFibGVcbiAgaW1wbGVtZW50cyBJVGVycmFmb3JtQWRkcmVzc2FibGVcbntcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICkge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUpO1xuICB9XG5cbiAgcHVibGljIGxvb2t1cChrZXk6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nKFxuICAgICAgdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKFxuICAgICAgICBgJHt0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZX1bXCIke2tleX1cIl1gLFxuICAgICAgKSxcbiAgICApO1xuICB9XG5cbiAgY29tcHV0ZUZxbigpOiBzdHJpbmcge1xuICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhcbiAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSh0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZSksXG4gICAgKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIE51bWJlck1hcFxuICBleHRlbmRzIENvbXBsZXhSZXNvbHZhYmxlXG4gIGltcGxlbWVudHMgSVRlcnJhZm9ybUFkZHJlc3NhYmxlXG57XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLFxuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlKTtcbiAgfVxuXG4gIHB1YmxpYyBsb29rdXAoa2V5OiBzdHJpbmcpOiBudW1iZXIge1xuICAgIHJldHVybiBUb2tlbi5hc051bWJlcihcbiAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgYCR7dGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGV9W1wiJHtrZXl9XCJdYCxcbiAgICAgICksXG4gICAgKTtcbiAgfVxuXG4gIGNvbXB1dGVGcW4oKTogc3RyaW5nIHtcbiAgICByZXR1cm4gVG9rZW4uYXNTdHJpbmcoXG4gICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUodGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGUpLFxuICAgICk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBCb29sZWFuTWFwXG4gIGV4dGVuZHMgQ29tcGxleFJlc29sdmFibGVcbiAgaW1wbGVtZW50cyBJVGVycmFmb3JtQWRkcmVzc2FibGVcbntcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICkge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUpO1xuICB9XG5cbiAgcHVibGljIGxvb2t1cChrZXk6IHN0cmluZyk6IElSZXNvbHZhYmxlIHtcbiAgICByZXR1cm4gdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKFxuICAgICAgYCR7dGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGV9W1wiJHtrZXl9XCJdYCxcbiAgICApO1xuICB9XG5cbiAgY29tcHV0ZUZxbigpOiBzdHJpbmcge1xuICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhcbiAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSh0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZSksXG4gICAgKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIEFueU1hcCBleHRlbmRzIENvbXBsZXhSZXNvbHZhYmxlIGltcGxlbWVudHMgSVRlcnJhZm9ybUFkZHJlc3NhYmxlIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICkge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUpO1xuICB9XG5cbiAgcHVibGljIGxvb2t1cChrZXk6IHN0cmluZyk6IGFueSB7XG4gICAgcmV0dXJuIFRva2VuLmFzQW55KFxuICAgICAgdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKFxuICAgICAgICBgJHt0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZX1bXCIke2tleX1cIl1gLFxuICAgICAgKSxcbiAgICApO1xuICB9XG5cbiAgY29tcHV0ZUZxbigpOiBzdHJpbmcge1xuICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhcbiAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSh0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZSksXG4gICAgKTtcbiAgfVxufVxuXG4vKipcbiAqIEBkZXByZWNhdGVkIEdvaW5nIHRvIGJlIHJlcGxhY2VkIGJ5IEFycmF5IG9mIENvbXBsZXhMaXN0SXRlbVxuICogYW5kIHdpbGwgYmUgcmVtb3ZlZCBpbiB0aGUgZnV0dXJlXG4gKi9cbmV4cG9ydCBjbGFzcyBDb21wbGV4Q29tcHV0ZWRMaXN0IGV4dGVuZHMgQ29tcGxleENvbXB1dGVkQXR0cmlidXRlIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICAgcHJvdGVjdGVkIGNvbXBsZXhDb21wdXRlZExpc3RJbmRleDogc3RyaW5nLFxuICAgIHByb3RlY3RlZCB3cmFwc1NldD86IGJvb2xlYW4sXG4gICkge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUpO1xuICAgIHRocm93IHByb3ZpZGVyVmVyc2lvbk1pc21hdGNoKCk7XG4gIH1cblxuICBwdWJsaWMgaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShwcm9wZXJ0eTogc3RyaW5nKSB7XG4gICAgaWYgKHRoaXMud3JhcHNTZXQpIHtcbiAgICAgIHJldHVybiBwcm9wZXJ0eUFjY2VzcyhcbiAgICAgICAgRm4udG9saXN0KFxuICAgICAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgICAgIHRoaXMudGVycmFmb3JtQXR0cmlidXRlLFxuICAgICAgICAgICksXG4gICAgICAgICksXG4gICAgICAgIFt0aGlzLmNvbXBsZXhDb21wdXRlZExpc3RJbmRleCwgcHJvcGVydHldLFxuICAgICAgKTtcbiAgICB9XG5cbiAgICByZXR1cm4gdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKFxuICAgICAgYCR7dGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGV9WyR7dGhpcy5jb21wbGV4Q29tcHV0ZWRMaXN0SW5kZXh9XS4ke3Byb3BlcnR5fWAsXG4gICAgKTtcbiAgfVxuXG4gIGNvbXB1dGVGcW4oKTogc3RyaW5nIHtcbiAgICBpZiAodGhpcy53cmFwc1NldCkge1xuICAgICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nKFxuICAgICAgICBwcm9wZXJ0eUFjY2VzcyhcbiAgICAgICAgICBGbi50b2xpc3QoXG4gICAgICAgICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgICAgICAgIHRoaXMudGVycmFmb3JtQXR0cmlidXRlLFxuICAgICAgICAgICAgKSxcbiAgICAgICAgICApLFxuICAgICAgICAgIFt0aGlzLmNvbXBsZXhDb21wdXRlZExpc3RJbmRleF0sXG4gICAgICAgICksXG4gICAgICApO1xuICAgIH1cblxuICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhcbiAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgYCR7dGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGV9WyR7dGhpcy5jb21wbGV4Q29tcHV0ZWRMaXN0SW5kZXh9XWAsXG4gICAgICApLFxuICAgICk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBDb21wbGV4TGlzdFxuICBleHRlbmRzIENvbXBsZXhSZXNvbHZhYmxlXG4gIGltcGxlbWVudHMgSVRlcnJhZm9ybUFkZHJlc3NhYmxlXG57XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLFxuICAgIHByb3RlY3RlZCB3cmFwc1NldDogYm9vbGVhbixcbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSk7XG4gIH1cblxuICBjb21wdXRlRnFuKCk6IHN0cmluZyB7XG4gICAgaWYgKHRoaXMud3JhcHNTZXQpIHtcbiAgICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhcbiAgICAgICAgRm4udG9saXN0KFxuICAgICAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgICAgIHRoaXMudGVycmFmb3JtQXR0cmlidXRlLFxuICAgICAgICAgICksXG4gICAgICAgICksXG4gICAgICApO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gVG9rZW4uYXNTdHJpbmcoXG4gICAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgICB0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZSxcbiAgICAgICAgKSxcbiAgICAgICk7XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0aW5nIGFuIGl0ZXJhdG9yIGZvciB0aGlzIGNvbXBsZXggbGlzdC5cbiAgICogVGhlIGxpc3Qgd2lsbCBiZSBjb252ZXJ0ZWQgaW50byBhIG1hcCB3aXRoIHRoZSBtYXBLZXlBdHRyaWJ1dGVOYW1lIGFzIHRoZSBrZXkuXG4gICAqIEBwYXJhbSBtYXBLZXlBdHRyaWJ1dGVOYW1lXG4gICAqIEByZXR1cm5zXG4gICAqL1xuICBwdWJsaWMgYWxsV2l0aE1hcEtleShcbiAgICBtYXBLZXlBdHRyaWJ1dGVOYW1lOiBzdHJpbmcsXG4gICk6IER5bmFtaWNMaXN0VGVycmFmb3JtSXRlcmF0b3Ige1xuICAgIHJldHVybiBUZXJyYWZvcm1JdGVyYXRvci5mcm9tQ29tcGxleExpc3QoXG4gICAgICBUb2tlbi5hc0FueSh0aGlzLmNvbXB1dGVGcW4oKSksXG4gICAgICBtYXBLZXlBdHRyaWJ1dGVOYW1lLFxuICAgICk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBCb29sZWFuTGlzdCBleHRlbmRzIENvbXBsZXhMaXN0IHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICAgcHJvdGVjdGVkIHdyYXBzU2V0OiBib29sZWFuLFxuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCB3cmFwc1NldCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0KGluZGV4OiBudW1iZXIpOiBJUmVzb2x2YWJsZSB7XG4gICAgcmV0dXJuIEZuLmVsZW1lbnQodGhpcywgaW5kZXgpO1xuICB9XG59XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgY2xhc3MgU3RyaW5nTGlzdExpc3QgZXh0ZW5kcyBDb21wbGV4TGlzdCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLFxuICAgIHByb3RlY3RlZCB3cmFwc1NldDogYm9vbGVhbixcbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgd3JhcHNTZXQpO1xuICB9XG5cbiAgcHVibGljIGdldChpbmRleDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIFRva2VuLmFzTGlzdChcbiAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgYCR7dGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGV9WyR7aW5kZXh9XWAsXG4gICAgICApLFxuICAgICk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBOdW1iZXJMaXN0TGlzdCBleHRlbmRzIENvbXBsZXhMaXN0IHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICAgcHJvdGVjdGVkIHdyYXBzU2V0OiBib29sZWFuLFxuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCB3cmFwc1NldCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0KGluZGV4OiBudW1iZXIpIHtcbiAgICByZXR1cm4gVG9rZW4uYXNOdW1iZXJMaXN0KFxuICAgICAgdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKFxuICAgICAgICBgJHt0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZX1bJHtpbmRleH1dYCxcbiAgICAgICksXG4gICAgKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIEJvb2xlYW5MaXN0TGlzdCBleHRlbmRzIENvbXBsZXhMaXN0IHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICAgcHJvdGVjdGVkIHdyYXBzU2V0OiBib29sZWFuLFxuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCB3cmFwc1NldCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0KGluZGV4OiBudW1iZXIpIHtcbiAgICAvLyBUaGlzIGlzbid0IGZ1bGx5IHN1cHBvcnRlZFxuICAgIHJldHVybiB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICBgJHt0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZX1bJHtpbmRleH1dYCxcbiAgICApO1xuICB9XG59XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgY2xhc3MgQW55TGlzdExpc3QgZXh0ZW5kcyBDb21wbGV4TGlzdCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLFxuICAgIHByb3RlY3RlZCB3cmFwc1NldDogYm9vbGVhbixcbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgd3JhcHNTZXQpO1xuICB9XG5cbiAgcHVibGljIGdldChpbmRleDogbnVtYmVyKSB7XG4gICAgLy8gVGhpcyBpc24ndCBmdWxseSBzdXBwb3J0ZWRcbiAgICByZXR1cm4gdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKFxuICAgICAgYCR7dGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGV9WyR7aW5kZXh9XWAsXG4gICAgKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIENvbXBsZXhNYXBcbiAgZXh0ZW5kcyBDb21wbGV4UmVzb2x2YWJsZVxuICBpbXBsZW1lbnRzIElUZXJyYWZvcm1BZGRyZXNzYWJsZVxue1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZyxcbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSk7XG4gIH1cblxuICBjb21wdXRlRnFuKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nKFxuICAgICAgdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHRoaXMudGVycmFmb3JtQXR0cmlidXRlKSxcbiAgICApO1xuICB9XG5cbiAgaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShwcm9wZXJ0eTogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHByb3BlcnR5QWNjZXNzKFxuICAgICAgdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKHRoaXMudGVycmFmb3JtQXR0cmlidXRlKSxcbiAgICAgIFtwcm9wZXJ0eV0sXG4gICAgKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIENvbXBsZXhPYmplY3QgZXh0ZW5kcyBDb21wbGV4Q29tcHV0ZWRBdHRyaWJ1dGUge1xuICAvKipcbiAgICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlXG4gICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGVcbiAgICogQHBhcmFtIGNvbXBsZXhPYmplY3RJbmRleCB0aGUgaW5kZXggb2YgdGhlIGNvbXBsZXggb2JqZWN0IGluIGEgbGlzdFxuICAgKiBAcGFyYW0gY29tcGxleE9iamVjdElzRnJvbVNldCBzZXQgdG8gdHJ1ZSBpZiB0aGlzIGl0ZW0gaXMgZnJvbSBpbnNpZGUgYSBzZXQgYW5kIG5lZWRzIHRvbGlzdCgpIGZvciBhY2Nlc3NpbmcgaXRcbiAgICogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgc2V0IHRvIFwiMFwiIGZvciBzaW5nbGUgbGlzdCBpdGVtc1xuICAgKi9cbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICAgcHJvdGVjdGVkIGNvbXBsZXhPYmplY3RJc0Zyb21TZXQ6IGJvb2xlYW4sXG4gICAgcHJvdGVjdGVkIGNvbXBsZXhPYmplY3RJbmRleD86IG51bWJlciB8IHN0cmluZyxcbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSk7XG4gIH1cblxuICBwdWJsaWMgaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShwcm9wZXJ0eTogc3RyaW5nKSB7XG4gICAgaWYgKHRoaXMuY29tcGxleE9iamVjdElzRnJvbVNldCkge1xuICAgICAgcmV0dXJuIHByb3BlcnR5QWNjZXNzKFxuICAgICAgICBGbi50b2xpc3QoXG4gICAgICAgICAgdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKFxuICAgICAgICAgICAgdGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGUsXG4gICAgICAgICAgKSxcbiAgICAgICAgKSxcbiAgICAgICAgW3RoaXMuY29tcGxleE9iamVjdEluZGV4LCBwcm9wZXJ0eV0sXG4gICAgICApO1xuICAgIH1cblxuICAgIHJldHVybiB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICB0aGlzLmNvbXBsZXhPYmplY3RJbmRleCAhPT0gdW5kZWZpbmVkXG4gICAgICAgID8gYCR7dGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGV9WyR7dGhpcy5jb21wbGV4T2JqZWN0SW5kZXh9XS4ke3Byb3BlcnR5fWBcbiAgICAgICAgOiBgJHt0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZX0uJHtwcm9wZXJ0eX1gLFxuICAgICk7XG4gIH1cblxuICBwcm90ZWN0ZWQgaW50ZXJwb2xhdGlvbkFzTGlzdCgpIHtcbiAgICByZXR1cm4gdGhpcy50ZXJyYWZvcm1SZXNvdXJjZS5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKFxuICAgICAgYCR7dGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGV9LipgLFxuICAgICk7XG4gIH1cblxuICBjb21wdXRlRnFuKCk6IHN0cmluZyB7XG4gICAgaWYgKHRoaXMuY29tcGxleE9iamVjdElzRnJvbVNldCkge1xuICAgICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nKFxuICAgICAgICBwcm9wZXJ0eUFjY2VzcyhcbiAgICAgICAgICBGbi50b2xpc3QoXG4gICAgICAgICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgICAgICAgIHRoaXMudGVycmFmb3JtQXR0cmlidXRlLFxuICAgICAgICAgICAgKSxcbiAgICAgICAgICApLFxuICAgICAgICAgIFt0aGlzLmNvbXBsZXhPYmplY3RJbmRleF0sXG4gICAgICAgICksXG4gICAgICApO1xuICAgIH1cblxuICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhcbiAgICAgIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgICAgdGhpcy5jb21wbGV4T2JqZWN0SW5kZXggIT09IHVuZGVmaW5lZFxuICAgICAgICAgID8gYCR7dGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGV9WyR7dGhpcy5jb21wbGV4T2JqZWN0SW5kZXh9XWBcbiAgICAgICAgICA6IHRoaXMudGVycmFmb3JtQXR0cmlidXRlLFxuICAgICAgKSxcbiAgICApO1xuICB9XG59XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgTWFwTGlzdFxuICBleHRlbmRzIENvbXBsZXhSZXNvbHZhYmxlXG4gIGltcGxlbWVudHMgSVRlcnJhZm9ybUFkZHJlc3NhYmxlLCBJSW50ZXJwb2xhdGluZ1BhcmVudFxue1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZyxcbiAgICBwcm90ZWN0ZWQgd3JhcHNTZXQ6IGJvb2xlYW4sXG4gICkge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUpO1xuICB9XG5cbiAgY29tcHV0ZUZxbigpOiBzdHJpbmcge1xuICAgIGlmICh0aGlzLndyYXBzU2V0KSB7XG4gICAgICByZXR1cm4gVG9rZW4uYXNTdHJpbmcoXG4gICAgICAgIEZuLnRvbGlzdChcbiAgICAgICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgICAgICB0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZSxcbiAgICAgICAgICApLFxuICAgICAgICApLFxuICAgICAgKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nKFxuICAgICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgICAgdGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGUsXG4gICAgICAgICksXG4gICAgICApO1xuICAgIH1cbiAgfVxuXG4gIGludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUocHJvcGVydHk6IHN0cmluZyk6IElSZXNvbHZhYmxlIHtcbiAgICBpZiAodGhpcy53cmFwc1NldCkge1xuICAgICAgY29uc3QgbWF0Y2hlcyA9IHByb3BlcnR5Lm1hdGNoKC9cXFsoW15cXF1dKilcXF0vKTsgLy8gbmVlZCB0byBleHRyYWN0IG91dCB0aGUgaW5kZXhcbiAgICAgIGlmIChtYXRjaGVzKSB7XG4gICAgICAgIHJldHVybiBwcm9wZXJ0eUFjY2VzcyhcbiAgICAgICAgICBGbi50b2xpc3QoXG4gICAgICAgICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgICAgICAgIHRoaXMudGVycmFmb3JtQXR0cmlidXRlLFxuICAgICAgICAgICAgKSxcbiAgICAgICAgICApLFxuICAgICAgICAgIFttYXRjaGVzWzFdLCBwcm9wZXJ0eV0sXG4gICAgICAgICk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgIGAke3RoaXMudGVycmFmb3JtQXR0cmlidXRlfSR7cHJvcGVydHl9YCxcbiAgICApO1xuICB9XG59XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgY2xhc3MgU3RyaW5nTWFwTGlzdCBleHRlbmRzIE1hcExpc3Qge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtUmVzb3VyY2U6IElJbnRlcnBvbGF0aW5nUGFyZW50LFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZyxcbiAgICBwcm90ZWN0ZWQgd3JhcHNTZXQ6IGJvb2xlYW4sXG4gICkge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIHdyYXBzU2V0KTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQoaW5kZXg6IG51bWJlcikge1xuICAgIHJldHVybiBuZXcgU3RyaW5nTWFwKHRoaXMsIGBbJHtpbmRleH1dYCk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBOdW1iZXJNYXBMaXN0IGV4dGVuZHMgTWFwTGlzdCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLFxuICAgIHByb3RlY3RlZCB3cmFwc1NldDogYm9vbGVhbixcbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgd3JhcHNTZXQpO1xuICB9XG5cbiAgcHVibGljIGdldChpbmRleDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIG5ldyBOdW1iZXJNYXAodGhpcywgYFske2luZGV4fV1gKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIEJvb2xlYW5NYXBMaXN0IGV4dGVuZHMgTWFwTGlzdCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLFxuICAgIHByb3RlY3RlZCB3cmFwc1NldDogYm9vbGVhbixcbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgd3JhcHNTZXQpO1xuICB9XG5cbiAgcHVibGljIGdldChpbmRleDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIG5ldyBCb29sZWFuTWFwKHRoaXMsIGBbJHtpbmRleH1dYCk7XG4gIH1cbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGpzZG9jL3JlcXVpcmUtanNkb2NcbmV4cG9ydCBjbGFzcyBBbnlNYXBMaXN0IGV4dGVuZHMgTWFwTGlzdCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLFxuICAgIHByb3RlY3RlZCB3cmFwc1NldDogYm9vbGVhbixcbiAgKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgd3JhcHNTZXQpO1xuICB9XG5cbiAgcHVibGljIGdldChpbmRleDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIG5ldyBBbnlNYXAodGhpcywgYFske2luZGV4fV1gKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIFN0cmluZ0xpc3RNYXAgZXh0ZW5kcyBDb21wbGV4TWFwIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICkge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUpO1xuICB9XG5cbiAgcHVibGljIGdldChrZXk6IHN0cmluZykge1xuICAgIHJldHVybiBUb2tlbi5hc0xpc3QoXG4gICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgIGAke3RoaXMudGVycmFmb3JtQXR0cmlidXRlfVske2tleX1dYCxcbiAgICAgICksXG4gICAgKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIE51bWJlckxpc3RNYXAgZXh0ZW5kcyBDb21wbGV4TWFwIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICkge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUpO1xuICB9XG5cbiAgcHVibGljIGdldChrZXk6IHN0cmluZykge1xuICAgIHJldHVybiBUb2tlbi5hc051bWJlckxpc3QoXG4gICAgICB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICAgIGAke3RoaXMudGVycmFmb3JtQXR0cmlidXRlfVske2tleX1dYCxcbiAgICAgICksXG4gICAgKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIEJvb2xlYW5MaXN0TWFwIGV4dGVuZHMgQ29tcGxleE1hcCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogSUludGVycG9sYXRpbmdQYXJlbnQsXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLFxuICApIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQoa2V5OiBzdHJpbmcpIHtcbiAgICAvLyBUaGlzIGlzbid0IGZ1bGx5IHN1cHBvcnRlZFxuICAgIHJldHVybiB0aGlzLnRlcnJhZm9ybVJlc291cmNlLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoXG4gICAgICBgJHt0aGlzLnRlcnJhZm9ybUF0dHJpYnV0ZX1bJHtrZXl9XWAsXG4gICAgKTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIEFueUxpc3RNYXAgZXh0ZW5kcyBDb21wbGV4TWFwIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBJSW50ZXJwb2xhdGluZ1BhcmVudCxcbiAgICBwcm90ZWN0ZWQgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsXG4gICkge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUpO1xuICB9XG5cbiAgcHVibGljIGdldChrZXk6IHN0cmluZykge1xuICAgIC8vIFRoaXMgaXNuJ3QgZnVsbHkgc3VwcG9ydGVkXG4gICAgcmV0dXJuIHRoaXMudGVycmFmb3JtUmVzb3VyY2UuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZShcbiAgICAgIGAke3RoaXMudGVycmFmb3JtQXR0cmlidXRlfVske2tleX1dYCxcbiAgICApO1xuICB9XG59XG4iXX0=