import { IResolvable, IResolveContext } from "./tokens";
import { IInterpolatingParent, ITerraformAddressable } from "./terraform-addressable";
import { DynamicListTerraformIterator } from ".";
declare abstract class ComplexResolvable implements IResolvable, ITerraformAddressable {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    readonly creationStack: string[];
    /**
     * @internal
     */
    protected _fqn?: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    abstract computeFqn(): string;
    get fqn(): string;
    resolve(_context: IResolveContext): any;
    toString(): string;
}
declare abstract class ComplexComputedAttribute extends ComplexResolvable implements IInterpolatingParent {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    getStringAttribute(terraformAttribute: string): string;
    getNumberAttribute(terraformAttribute: string): number;
    getListAttribute(terraformAttribute: string): string[];
    getBooleanAttribute(terraformAttribute: string): IResolvable;
    getNumberListAttribute(terraformAttribute: string): number[];
    getStringMapAttribute(terraformAttribute: string): {
        [key: string]: string;
    };
    getNumberMapAttribute(terraformAttribute: string): {
        [key: string]: number;
    };
    getBooleanMapAttribute(terraformAttribute: string): {
        [key: string]: boolean;
    };
    getAnyMapAttribute(terraformAttribute: string): {
        [key: string]: any;
    };
    abstract interpolationForAttribute(terraformAttribute: string): any;
}
export declare class StringMap extends ComplexResolvable implements ITerraformAddressable {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    lookup(key: string): string;
    computeFqn(): string;
}
export declare class NumberMap extends ComplexResolvable implements ITerraformAddressable {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    lookup(key: string): number;
    computeFqn(): string;
}
export declare class BooleanMap extends ComplexResolvable implements ITerraformAddressable {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    lookup(key: string): IResolvable;
    computeFqn(): string;
}
export declare class AnyMap extends ComplexResolvable implements ITerraformAddressable {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    lookup(key: string): any;
    computeFqn(): string;
}
/**
 * @deprecated Going to be replaced by Array of ComplexListItem
 * and will be removed in the future
 */
export declare class ComplexComputedList extends ComplexComputedAttribute {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected complexComputedListIndex: string;
    protected wrapsSet?: boolean | undefined;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, complexComputedListIndex: string, wrapsSet?: boolean | undefined);
    interpolationForAttribute(property: string): IResolvable;
    computeFqn(): string;
}
export declare abstract class ComplexList extends ComplexResolvable implements ITerraformAddressable {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    computeFqn(): string;
    /**
     * Creating an iterator for this complex list.
     * The list will be converted into a map with the mapKeyAttributeName as the key.
     * @param mapKeyAttributeName
     * @returns
     */
    allWithMapKey(mapKeyAttributeName: string): DynamicListTerraformIterator;
}
export declare class BooleanList extends ComplexList {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    get(index: number): IResolvable;
}
export declare class StringListList extends ComplexList {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    get(index: number): string[];
}
export declare class NumberListList extends ComplexList {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    get(index: number): number[];
}
export declare class BooleanListList extends ComplexList {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    get(index: number): IResolvable;
}
export declare class AnyListList extends ComplexList {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    get(index: number): IResolvable;
}
export declare abstract class ComplexMap extends ComplexResolvable implements ITerraformAddressable {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    computeFqn(): string;
    interpolationForAttribute(property: string): IResolvable;
}
export declare class ComplexObject extends ComplexComputedAttribute {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected complexObjectIsFromSet: boolean;
    protected complexObjectIndex?: number | string | undefined;
    /**
     * @param terraformResource
     * @param terraformAttribute
     * @param complexObjectIndex the index of the complex object in a list
     * @param complexObjectIsFromSet set to true if this item is from inside a set and needs tolist() for accessing it
     *                               set to "0" for single list items
     */
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, complexObjectIsFromSet: boolean, complexObjectIndex?: number | string | undefined);
    interpolationForAttribute(property: string): IResolvable;
    protected interpolationAsList(): IResolvable;
    computeFqn(): string;
}
export declare abstract class MapList extends ComplexResolvable implements ITerraformAddressable, IInterpolatingParent {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    computeFqn(): string;
    interpolationForAttribute(property: string): IResolvable;
}
export declare class StringMapList extends MapList {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    get(index: number): StringMap;
}
export declare class NumberMapList extends MapList {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    get(index: number): NumberMap;
}
export declare class BooleanMapList extends MapList {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    get(index: number): BooleanMap;
}
export declare class AnyMapList extends MapList {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    get(index: number): AnyMap;
}
export declare class StringListMap extends ComplexMap {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    get(key: string): string[];
}
export declare class NumberListMap extends ComplexMap {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    get(key: string): number[];
}
export declare class BooleanListMap extends ComplexMap {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    get(key: string): IResolvable;
}
export declare class AnyListMap extends ComplexMap {
    protected terraformResource: IInterpolatingParent;
    protected terraformAttribute: string;
    constructor(terraformResource: IInterpolatingParent, terraformAttribute: string);
    get(key: string): IResolvable;
}
export {};
