"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateS3 = exports.S3Backend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
// eslint-disable-next-line jsdoc/require-jsdoc
class S3Backend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "s3");
        this.props = props;
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    synthesizeHclAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateS3(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
exports.S3Backend = S3Backend;
_a = JSII_RTTI_SYMBOL_1;
S3Backend[_a] = { fqn: "cdktf.S3Backend", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteStateS3 extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "s3", config);
    }
}
exports.DataTerraformRemoteStateS3 = DataTerraformRemoteStateS3;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateS3[_b] = { fqn: "cdktf.DataTerraformRemoteStateS3", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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