"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrefixedRemoteWorkspaces = exports.NamedRemoteWorkspace = exports.DataTerraformRemoteState = exports.RemoteBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
const cloud_backend_1 = require("./cloud-backend");
// eslint-disable-next-line jsdoc/require-jsdoc
class RemoteBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "remote");
        this.props = props;
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    synthesizeHclAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    toMetadata() {
        const cloud = (0, cloud_backend_1.getHostNameType)(this.props.hostname);
        return { ...super.toMetadata(), cloud };
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteState(scope, name, {
            ...this.props,
        });
    }
}
exports.RemoteBackend = RemoteBackend;
_a = JSII_RTTI_SYMBOL_1;
RemoteBackend[_a] = { fqn: "cdktf.RemoteBackend", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteState extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "remote", config);
    }
}
exports.DataTerraformRemoteState = DataTerraformRemoteState;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteState[_b] = { fqn: "cdktf.DataTerraformRemoteState", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class NamedRemoteWorkspace {
    constructor(name) {
        this.name = name;
    }
}
exports.NamedRemoteWorkspace = NamedRemoteWorkspace;
_c = JSII_RTTI_SYMBOL_1;
NamedRemoteWorkspace[_c] = { fqn: "cdktf.NamedRemoteWorkspace", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class PrefixedRemoteWorkspaces {
    constructor(prefix) {
        this.prefix = prefix;
    }
}
exports.PrefixedRemoteWorkspaces = PrefixedRemoteWorkspaces;
_d = JSII_RTTI_SYMBOL_1;
PrefixedRemoteWorkspaces[_d] = { fqn: "cdktf.PrefixedRemoteWorkspaces", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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