"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStatePg = exports.PgBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
// eslint-disable-next-line jsdoc/require-jsdoc
class PgBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "pg");
        this.props = props;
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    synthesizeHclAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStatePg(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
exports.PgBackend = PgBackend;
_a = JSII_RTTI_SYMBOL_1;
PgBackend[_a] = { fqn: "cdktf.PgBackend", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteStatePg extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "pg", config);
    }
}
exports.DataTerraformRemoteStatePg = DataTerraformRemoteStatePg;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStatePg[_b] = { fqn: "cdktf.DataTerraformRemoteStatePg", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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