"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateLocal = exports.LocalBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const path = require("path");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
const __1 = require("..");
// eslint-disable-next-line jsdoc/require-jsdoc
class LocalBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props = {}) {
        super(scope, "backend", "local");
        const stackId = __1.TerraformStack.of(this).node.id;
        this.props = {
            ...props,
            path: props.path || path.join(process.cwd(), `terraform.${stackId}.tfstate`),
        };
    }
    synthesizeHclAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, fromStack) {
        return new DataTerraformRemoteStateLocal(scope, name, {
            workspaceDir: this.props.workspaceDir,
            path: this.props.path ||
                path.join(process.cwd(), `terraform.${fromStack}.tfstate`),
            workspace: "${terraform.workspace}",
        });
    }
}
exports.LocalBackend = LocalBackend;
_a = JSII_RTTI_SYMBOL_1;
LocalBackend[_a] = { fqn: "cdktf.LocalBackend", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteStateLocal extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "local", config);
    }
}
exports.DataTerraformRemoteStateLocal = DataTerraformRemoteStateLocal;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateLocal[_b] = { fqn: "cdktf.DataTerraformRemoteStateLocal", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9jYWwtYmFja2VuZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxvY2FsLWJhY2tlbmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwrQkFBK0I7QUFDL0IsbUNBQW1DO0FBQ25DLDZCQUE2QjtBQUU3Qiw0REFBd0Q7QUFDeEQsa0NBQTBDO0FBQzFDLHNFQUdtQztBQUNuQywwQkFBb0M7QUFFcEMsK0NBQStDO0FBQy9DLE1BQWEsWUFBYSxTQUFRLG9DQUFnQjtJQUVoRCxZQUFZLEtBQWdCLEVBQUUsUUFBNEIsRUFBRTtRQUMxRCxLQUFLLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRSxPQUFPLENBQUMsQ0FBQztRQUVqQyxNQUFNLE9BQU8sR0FBRyxrQkFBYyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO1FBQ2hELElBQUksQ0FBQyxLQUFLLEdBQUc7WUFDWCxHQUFHLEtBQUs7WUFDUixJQUFJLEVBQ0YsS0FBSyxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUUsRUFBRSxhQUFhLE9BQU8sVUFBVSxDQUFDO1NBQ3pFLENBQUM7SUFDSixDQUFDO0lBRVMsdUJBQXVCO1FBQy9CLE9BQU8sSUFBQSxzQkFBZSxFQUFDLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRVMsb0JBQW9CO1FBQzVCLE9BQU8sSUFBQSxzQkFBZSxFQUFDLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRU0sd0JBQXdCLENBQzdCLEtBQWdCLEVBQ2hCLElBQVksRUFDWixTQUFpQjtRQUVqQixPQUFPLElBQUksNkJBQTZCLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRTtZQUNwRCxZQUFZLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZO1lBQ3JDLElBQUksRUFDRixJQUFJLENBQUMsS0FBSyxDQUFDLElBQUk7Z0JBQ2YsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxFQUFFLEVBQUUsYUFBYSxTQUFTLFVBQVUsQ0FBQztZQUM1RCxTQUFTLEVBQUUsd0JBQXdCO1NBQ3BDLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBakNILG9DQWtDQzs7O0FBRUQsK0NBQStDO0FBQy9DLE1BQWEsNkJBQThCLFNBQVEsNkNBQW9CO0lBQ3JFLFlBQ0UsS0FBZ0IsRUFDaEIsRUFBVSxFQUNWLE1BQTJDO1FBRTNDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLE9BQU8sRUFBRSxNQUFNLENBQUMsQ0FBQztJQUNwQyxDQUFDOztBQVBILHNFQVFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluY1xuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1QTC0yLjBcbmltcG9ydCAqIGFzIHBhdGggZnJvbSBcInBhdGhcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBUZXJyYWZvcm1CYWNrZW5kIH0gZnJvbSBcIi4uL3RlcnJhZm9ybS1iYWNrZW5kXCI7XG5pbXBvcnQgeyBrZXlzVG9TbmFrZUNhc2UgfSBmcm9tIFwiLi4vdXRpbFwiO1xuaW1wb3J0IHtcbiAgVGVycmFmb3JtUmVtb3RlU3RhdGUsXG4gIERhdGFUZXJyYWZvcm1SZW1vdGVTdGF0ZUNvbmZpZyxcbn0gZnJvbSBcIi4uL3RlcnJhZm9ybS1yZW1vdGUtc3RhdGVcIjtcbmltcG9ydCB7IFRlcnJhZm9ybVN0YWNrIH0gZnJvbSBcIi4uXCI7XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBqc2RvYy9yZXF1aXJlLWpzZG9jXG5leHBvcnQgY2xhc3MgTG9jYWxCYWNrZW5kIGV4dGVuZHMgVGVycmFmb3JtQmFja2VuZCB7XG4gIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IExvY2FsQmFja2VuZENvbmZpZztcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgcHJvcHM6IExvY2FsQmFja2VuZENvbmZpZyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIFwiYmFja2VuZFwiLCBcImxvY2FsXCIpO1xuXG4gICAgY29uc3Qgc3RhY2tJZCA9IFRlcnJhZm9ybVN0YWNrLm9mKHRoaXMpLm5vZGUuaWQ7XG4gICAgdGhpcy5wcm9wcyA9IHtcbiAgICAgIC4uLnByb3BzLFxuICAgICAgcGF0aDpcbiAgICAgICAgcHJvcHMucGF0aCB8fCBwYXRoLmpvaW4ocHJvY2Vzcy5jd2QoKSwgYHRlcnJhZm9ybS4ke3N0YWNrSWR9LnRmc3RhdGVgKSxcbiAgICB9O1xuICB9XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVIY2xBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ga2V5c1RvU25ha2VDYXNlKHsgLi4udGhpcy5wcm9wcyB9KTtcbiAgfVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIGtleXNUb1NuYWtlQ2FzZSh7IC4uLnRoaXMucHJvcHMgfSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0UmVtb3RlU3RhdGVEYXRhU291cmNlKFxuICAgIHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgbmFtZTogc3RyaW5nLFxuICAgIGZyb21TdGFjazogc3RyaW5nLFxuICApOiBUZXJyYWZvcm1SZW1vdGVTdGF0ZSB7XG4gICAgcmV0dXJuIG5ldyBEYXRhVGVycmFmb3JtUmVtb3RlU3RhdGVMb2NhbChzY29wZSwgbmFtZSwge1xuICAgICAgd29ya3NwYWNlRGlyOiB0aGlzLnByb3BzLndvcmtzcGFjZURpcixcbiAgICAgIHBhdGg6XG4gICAgICAgIHRoaXMucHJvcHMucGF0aCB8fFxuICAgICAgICBwYXRoLmpvaW4ocHJvY2Vzcy5jd2QoKSwgYHRlcnJhZm9ybS4ke2Zyb21TdGFja30udGZzdGF0ZWApLFxuICAgICAgd29ya3NwYWNlOiBcIiR7dGVycmFmb3JtLndvcmtzcGFjZX1cIixcbiAgICB9KTtcbiAgfVxufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGNsYXNzIERhdGFUZXJyYWZvcm1SZW1vdGVTdGF0ZUxvY2FsIGV4dGVuZHMgVGVycmFmb3JtUmVtb3RlU3RhdGUge1xuICBjb25zdHJ1Y3RvcihcbiAgICBzY29wZTogQ29uc3RydWN0LFxuICAgIGlkOiBzdHJpbmcsXG4gICAgY29uZmlnOiBEYXRhVGVycmFmb3JtUmVtb3RlU3RhdGVMb2NhbENvbmZpZyxcbiAgKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBcImxvY2FsXCIsIGNvbmZpZyk7XG4gIH1cbn1cbi8qKlxuICogVGhlIGxvY2FsIGJhY2tlbmQgc3RvcmVzIHN0YXRlIG9uIHRoZSBsb2NhbCBmaWxlc3lzdGVtLFxuICogbG9ja3MgdGhhdCBzdGF0ZSB1c2luZyBzeXN0ZW0gQVBJcywgYW5kIHBlcmZvcm1zIG9wZXJhdGlvbnMgbG9jYWxseS5cbiAqXG4gKiBSZWFkIG1vcmUgYWJvdXQgdGhpcyBiYWNrZW5kIGluIHRoZSBUZXJyYWZvcm0gZG9jczpcbiAqIGh0dHBzOi8vZGV2ZWxvcGVyLmhhc2hpY29ycC5jb20vdGVycmFmb3JtL2xhbmd1YWdlL3NldHRpbmdzL2JhY2tlbmRzL2xvY2FsXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTG9jYWxCYWNrZW5kQ29uZmlnIHtcbiAgLyoqXG4gICAqIFBhdGggd2hlcmUgdGhlIHN0YXRlIGZpbGUgaXMgc3RvcmVkLlxuICAgKiBAZGVmYXVsdCAtIGRlZmF1bHRzIHRvIHRlcnJhZm9ybS4ke3N0YWNrSWR9LnRmc3RhdGVcbiAgICovXG4gIHJlYWRvbmx5IHBhdGg/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiAoT3B0aW9uYWwpIFRoZSBwYXRoIHRvIG5vbi1kZWZhdWx0IHdvcmtzcGFjZXMuXG4gICAqL1xuICByZWFkb25seSB3b3Jrc3BhY2VEaXI/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRGF0YVRlcnJhZm9ybVJlbW90ZVN0YXRlTG9jYWxDb25maWdcbiAgZXh0ZW5kcyBEYXRhVGVycmFmb3JtUmVtb3RlU3RhdGVDb25maWcsXG4gICAgTG9jYWxCYWNrZW5kQ29uZmlnIHt9XG4iXX0=