import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
export declare class LocalBackend extends TerraformBackend {
    private readonly props;
    constructor(scope: Construct, props?: LocalBackendConfig);
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    getRemoteStateDataSource(scope: Construct, name: string, fromStack: string): TerraformRemoteState;
}
export declare class DataTerraformRemoteStateLocal extends TerraformRemoteState {
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateLocalConfig);
}
/**
 * The local backend stores state on the local filesystem,
 * locks that state using system APIs, and performs operations locally.
 *
 * Read more about this backend in the Terraform docs:
 * https://developer.hashicorp.com/terraform/language/settings/backends/local
 */
export interface LocalBackendConfig {
    /**
     * Path where the state file is stored.
     * @default - defaults to terraform.${stackId}.tfstate
     */
    readonly path?: string;
    /**
     * (Optional) The path to non-default workspaces.
     */
    readonly workspaceDir?: string;
}
export interface DataTerraformRemoteStateLocalConfig extends DataTerraformRemoteStateConfig, LocalBackendConfig {
}
