"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateGcs = exports.GcsBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
// eslint-disable-next-line jsdoc/require-jsdoc
class GcsBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "gcs");
        this.props = props;
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    synthesizeHclAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateGcs(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
exports.GcsBackend = GcsBackend;
_a = JSII_RTTI_SYMBOL_1;
GcsBackend[_a] = { fqn: "cdktf.GcsBackend", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteStateGcs extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "gcs", config);
    }
}
exports.DataTerraformRemoteStateGcs = DataTerraformRemoteStateGcs;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateGcs[_b] = { fqn: "cdktf.DataTerraformRemoteStateGcs", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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