"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTerraformRemoteStateCos = exports.CosBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_backend_1 = require("../terraform-backend");
const util_1 = require("../util");
const terraform_remote_state_1 = require("../terraform-remote-state");
// eslint-disable-next-line jsdoc/require-jsdoc
class CosBackend extends terraform_backend_1.TerraformBackend {
    constructor(scope, props) {
        super(scope, "backend", "cos");
        this.props = props;
    }
    synthesizeAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    synthesizeHclAttributes() {
        return (0, util_1.keysToSnakeCase)({ ...this.props });
    }
    getRemoteStateDataSource(scope, name, _fromStack) {
        return new DataTerraformRemoteStateCos(scope, name, {
            ...this.props,
            workspace: "${terraform.workspace}",
        });
    }
}
exports.CosBackend = CosBackend;
_a = JSII_RTTI_SYMBOL_1;
CosBackend[_a] = { fqn: "cdktf.CosBackend", version: "0.21.0" };
// eslint-disable-next-line jsdoc/require-jsdoc
class DataTerraformRemoteStateCos extends terraform_remote_state_1.TerraformRemoteState {
    constructor(scope, id, config) {
        super(scope, id, "cos", config);
    }
}
exports.DataTerraformRemoteStateCos = DataTerraformRemoteStateCos;
_b = JSII_RTTI_SYMBOL_1;
DataTerraformRemoteStateCos[_b] = { fqn: "cdktf.DataTerraformRemoteStateCos", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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