"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.App = exports.CONTEXT_ENV = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const constructs_1 = require("constructs");
const fs = require("fs");
const package_json_1 = require("../package.json");
const annotations_1 = require("./annotations");
const manifest_1 = require("./manifest");
const terraform_stack_1 = require("./terraform-stack");
const errors_1 = require("./errors");
const APP_SYMBOL = Symbol.for("cdktf/App");
exports.CONTEXT_ENV = "CDKTF_CONTEXT_JSON";
/**
 * Represents a cdktf application.
 */
class App extends constructs_1.Construct {
    /**
     * Defines an app
     * @param config configuration
     */
    constructor(config = {}) {
        super(undefined, "");
        Object.defineProperty(this, APP_SYMBOL, { value: true });
        this.outdir = config.outdir ?? process.env.CDKTF_OUTDIR ?? "cdktf.out";
        const envHclOutput = process.env.SYNTH_HCL_OUTPUT;
        let hclOutput = config.hclOutput || false;
        if (envHclOutput !== undefined) {
            hclOutput = envHclOutput === "true";
        }
        this.hclOutput = hclOutput;
        this.targetStackId = process.env.CDKTF_TARGET_STACK_ID;
        this.skipValidation = config.skipValidation || false;
        this.skipBackendValidation = config.skipBackendValidation || false;
        this.loadContext(config.context);
        const node = this.node;
        if (config.stackTraces === false) {
            node.setContext(annotations_1.DISABLE_STACK_TRACE_IN_METADATA, true);
        }
        node.setContext("cdktfVersion", package_json_1.version);
        if (!fs.existsSync(this.outdir)) {
            fs.mkdirSync(this.outdir);
        }
        this.manifest = new manifest_1.Manifest(package_json_1.version, this.outdir, this.hclOutput);
    }
    static isApp(x) {
        return x !== null && typeof x === "object" && APP_SYMBOL in x;
    }
    static of(construct) {
        return _lookup(construct);
        // eslint-disable-next-line jsdoc/require-jsdoc
        function _lookup(c) {
            if (App.isApp(c)) {
                return c;
            }
            const node = c.node;
            if (!node.scope) {
                throw (0, errors_1.noAppFound)(construct.node.path);
            }
            return _lookup(node.scope);
        }
    }
    /**
     * Synthesizes all resources to the output directory
     */
    synth() {
        const session = {
            outdir: this.outdir,
            skipValidation: this.skipValidation,
            manifest: this.manifest,
        };
        const stacks = this.node
            .findAll()
            .filter(terraform_stack_1.TerraformStack.isStack);
        stacks.forEach((stack) => stack.prepareStack());
        stacks.forEach((stack) => stack.synthesizer.synthesize(session));
        if (!this.skipValidation) {
            const validations = this.node.validate();
            if (validations.length) {
                const errorList = validations.join("\n  ");
                throw (0, errors_1.appValidationFailure)(errorList);
            }
        }
        this.manifest.writeToFile();
    }
    /**
     * Creates a reference from one stack to another, invoked on prepareStack since it creates extra resources
     */
    crossStackReference(fromStack, toStack, identifier) {
        toStack.addDependency(fromStack);
        const outputId = fromStack.registerOutgoingCrossStackReference(identifier).friendlyUniqueId;
        const remoteState = toStack.registerIncomingCrossStackReference(fromStack);
        return remoteState.getString(outputId);
    }
    loadContext(defaults = {}) {
        const node = this.node;
        // prime with defaults passed through constructor
        for (const [k, v] of Object.entries(defaults)) {
            node.setContext(k, v);
        }
        // read from environment
        const contextJson = process.env[exports.CONTEXT_ENV];
        const contextFromEnvironment = contextJson ? JSON.parse(contextJson) : {};
        for (const [k, v] of Object.entries(contextFromEnvironment)) {
            node.setContext(k, v);
        }
    }
}
exports.App = App;
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "cdktf.App", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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