import { Construct, IConstruct } from "constructs";
import { Manifest } from "./manifest";
import { TerraformStack } from "./terraform-stack";
export declare const CONTEXT_ENV = "CDKTF_CONTEXT_JSON";
export interface AppConfig {
    /**
     * The directory to output Terraform resources.
     *
     * If you are using the CDKTF CLI, this value is automatically set from one of the following three sources:
     * - The `-o` / `--output` CLI option
     * - The `CDKTF_OUTDIR` environment variable
     * - The `outdir` key in `cdktf.json`
     *
     * If you are using the CDKTF CLI and want to set a different value here, you will also need to set the same value via one of the three ways specified above.
     *
     * The most common case to set this value is when you are using the CDKTF library directly (e.g. when writing unit tests).
     *
     * @default - CDKTF_OUTDIR if defined, otherwise "cdktf.out"
     */
    readonly outdir?: string;
    readonly stackTraces?: boolean;
    readonly hclOutput?: boolean;
    /**
     * Additional context values for the application.
     *
     * Context set by the CLI or the `context` key in `cdktf.json` has precedence.
     *
     * Context can be read from any construct using `node.getContext(key)`.
     *
     * @default - no additional context
     */
    readonly context?: {
        [key: string]: any;
    };
    /**
     * Whether to skip all validations during synthesis of the app
     *
     * @default - false
     */
    readonly skipValidation?: boolean;
    /**
     * Whether to skip backend validation during synthesis of the app
     *
     * @default - false
     */
    readonly skipBackendValidation?: boolean;
}
/**
 * Represents a cdktf application.
 */
export declare class App extends Construct {
    /**
     * The output directory into which resources will be synthesized.
     */
    readonly outdir: string;
    readonly hclOutput: boolean;
    /**
     * The stack which will be synthesized. If not set, all stacks will be synthesized.
     */
    readonly targetStackId: string | undefined;
    readonly manifest: Manifest;
    /**
     * Whether to skip all validations during synthesis of the app
     */
    readonly skipValidation: boolean;
    /**
     * Whether to skip backend validation during synthesis of the app
     */
    readonly skipBackendValidation: boolean;
    /**
     * Defines an app
     * @param config configuration
     */
    constructor(config?: AppConfig);
    static isApp(x: any): x is App;
    static of(construct: IConstruct): App;
    /**
     * Synthesizes all resources to the output directory
     */
    synth(): void;
    /**
     * Creates a reference from one stack to another, invoked on prepareStack since it creates extra resources
     */
    crossStackReference(fromStack: TerraformStack, toStack: TerraformStack, identifier: string): string;
    private loadContext;
}
