"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Annotations = exports.DISABLE_STACK_TRACE_IN_METADATA = exports.AnnotationMetadataEntryType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
var AnnotationMetadataEntryType;
(function (AnnotationMetadataEntryType) {
    AnnotationMetadataEntryType["INFO"] = "@cdktf/info";
    AnnotationMetadataEntryType["WARN"] = "@cdktf/warn";
    AnnotationMetadataEntryType["ERROR"] = "@cdktf/error";
})(AnnotationMetadataEntryType || (exports.AnnotationMetadataEntryType = AnnotationMetadataEntryType = {}));
exports.DISABLE_STACK_TRACE_IN_METADATA = "@cdktf/disable_stack_trace_in_metadata";
/**
 * Includes API for attaching annotations such as warning messages to constructs.
 */
class Annotations {
    /**
     * Returns the annotations API for a construct scope.
     * @param scope The scope
     */
    static of(scope) {
        return new Annotations(scope);
    }
    constructor(scope) {
        this.scope = scope;
        const disableTrace = scope.node.tryGetContext(exports.DISABLE_STACK_TRACE_IN_METADATA) || false;
        this.stackTraces = !disableTrace;
    }
    /**
     * Adds a warning metadata entry to this construct.
     *
     * The CLI will display the warning when an app is synthesized.
     * In a future release the CLI might introduce a --strict flag which
     * will then fail the synthesis if it encounters a warning.
     *
     * @param message The warning message.
     */
    addWarning(message) {
        this.addMessage(AnnotationMetadataEntryType.WARN, message);
    }
    /**
     * Adds an info metadata entry to this construct.
     *
     * The CLI will display the info message when apps are synthesized.
     *
     * @param message The info message.
     */
    addInfo(message) {
        this.addMessage(AnnotationMetadataEntryType.INFO, message);
    }
    /**
     * Adds an { "error": <message> } metadata entry to this construct.
     * The toolkit will fail synthesis when errors are reported.
     * @param message The error message.
     */
    addError(message) {
        this.addMessage(AnnotationMetadataEntryType.ERROR, message);
    }
    /**
     * Adds a message metadata entry to the construct node, to be displayed by the CDK CLI.
     * @param level The message level
     * @param message The message itself
     */
    addMessage(level, message) {
        this.scope.node.addMetadata(level, message, {
            stackTrace: this.stackTraces,
        });
    }
}
exports.Annotations = Annotations;
_a = JSII_RTTI_SYMBOL_1;
Annotations[_a] = { fqn: "cdktf.Annotations", version: "0.21.0" };
//# sourceMappingURL=data:application/json;base64,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