"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDeprecated = exports.describeTypeReference = exports.isClassOrInterfaceType = exports.isEnumType = exports.isInterfaceType = exports.isClassType = exports.TypeKind = exports.isMethod = exports.isUnionTypeReference = exports.isCollectionTypeReference = exports.isPrimitiveTypeReference = exports.isNamedTypeReference = exports.CANONICAL_ANY = exports.PrimitiveType = exports.CollectionKind = exports.Stability = exports.SchemaVersion = exports.SPEC_FILE_NAME_COMPRESSED = exports.SPEC_FILE_NAME = void 0;
/**
 * Expected file name for jsii assembly or instructions to compressed assembly.
 */
exports.SPEC_FILE_NAME = '.jsii';
/**
 * Expected file name for compressed assemblies.
 */
exports.SPEC_FILE_NAME_COMPRESSED = `${exports.SPEC_FILE_NAME}.gz`;
/**
 * Versions of the JSII Assembly Specification.
 */
var SchemaVersion;
(function (SchemaVersion) {
    SchemaVersion["LATEST"] = "jsii/0.10.0";
})(SchemaVersion = exports.SchemaVersion || (exports.SchemaVersion = {}));
/**
 * API Stability levels. These are modeled after the `node` stability index.
 *
 * @see https://nodejs.org/api/documentation.html#documentation_stability_index.
 */
var Stability;
(function (Stability) {
    /**
     * The API may emit warnings. Backward compatibility is not guaranteed.
     *
     * More information about the deprecation can usually be found in the
     * `deprecated` field.
     */
    Stability["Deprecated"] = "deprecated";
    /**
     * This API is still under active development and subject to non-backward
     * compatible changes or removal in any future version. Use of the API is
     * not recommended in production environments. Experimental APIs are not
     * subject to the Semantic Versioning model.
     */
    Stability["Experimental"] = "experimental";
    /**
     * This API is subject to the Semantic Versioning model and may not change
     * in breaking ways in a subsequent minor or patch version.
     */
    Stability["Stable"] = "stable";
    /**
     * This API is an representation of an API managed elsewhere and follows
     * the other API's versioning model.
     */
    Stability["External"] = "external";
})(Stability = exports.Stability || (exports.Stability = {}));
/**
 * Kinds of collections.
 */
var CollectionKind;
(function (CollectionKind) {
    /**
     * An array, or a list of some element type.
     */
    CollectionKind["Array"] = "array";
    /**
     * A map of a string to some element type.
     */
    CollectionKind["Map"] = "map";
})(CollectionKind = exports.CollectionKind || (exports.CollectionKind = {}));
/**
 * Kinds of primitive types.
 */
var PrimitiveType;
(function (PrimitiveType) {
    /**
     * A JSON date (represented as it's ISO-8601 string form).
     */
    PrimitiveType["Date"] = "date";
    /**
     * A plain string.
     */
    PrimitiveType["String"] = "string";
    /**
     * A number (integer or float).
     */
    PrimitiveType["Number"] = "number";
    /**
     * A boolean value.
     */
    PrimitiveType["Boolean"] = "boolean";
    /**
     * A JSON object
     */
    PrimitiveType["Json"] = "json";
    /**
     * Value with "any" or "unknown" type (aka Object). Values typed `any` may
     * be `null` or `undefined`.
     */
    PrimitiveType["Any"] = "any";
})(PrimitiveType = exports.PrimitiveType || (exports.PrimitiveType = {}));
/**
 * The standard representation of the `any` type (includes optionality marker).
 */
exports.CANONICAL_ANY = {
    primitive: PrimitiveType.Any,
};
function isNamedTypeReference(ref) {
    return !!ref?.fqn;
}
exports.isNamedTypeReference = isNamedTypeReference;
function isPrimitiveTypeReference(ref) {
    return !!ref?.primitive;
}
exports.isPrimitiveTypeReference = isPrimitiveTypeReference;
function isCollectionTypeReference(ref) {
    return !!ref?.collection;
}
exports.isCollectionTypeReference = isCollectionTypeReference;
function isUnionTypeReference(ref) {
    return !!ref?.union;
}
exports.isUnionTypeReference = isUnionTypeReference;
/**
 * Determines whether a Callable is a Method or not.
 *
 * @param callable the callable to be checked.
 */
function isMethod(callable) {
    return !!callable.name;
}
exports.isMethod = isMethod;
/**
 * Kinds of types.
 */
var TypeKind;
(function (TypeKind) {
    TypeKind["Class"] = "class";
    TypeKind["Enum"] = "enum";
    TypeKind["Interface"] = "interface";
})(TypeKind = exports.TypeKind || (exports.TypeKind = {}));
function isClassType(type) {
    return type?.kind === TypeKind.Class;
}
exports.isClassType = isClassType;
function isInterfaceType(type) {
    return type?.kind === TypeKind.Interface;
}
exports.isInterfaceType = isInterfaceType;
function isEnumType(type) {
    return type?.kind === TypeKind.Enum;
}
exports.isEnumType = isEnumType;
/**
 * Return whether this type is a class or interface type
 */
function isClassOrInterfaceType(type) {
    return isClassType(type) || isInterfaceType(type);
}
exports.isClassOrInterfaceType = isClassOrInterfaceType;
/**
 * Return a string representation of the given type reference.
 */
function describeTypeReference(type) {
    if (type === undefined) {
        return 'void';
    }
    if (isNamedTypeReference(type)) {
        return type.fqn;
    }
    if (isPrimitiveTypeReference(type)) {
        return type.primitive;
    }
    if (isCollectionTypeReference(type)) {
        return `${type.collection.kind}<${describeTypeReference(type.collection.elementtype)}>`;
    }
    if (isUnionTypeReference(type)) {
        const unionType = type.union.types.map(describeTypeReference).join(' | ');
        return unionType;
    }
    throw new Error('Unrecognized type reference');
}
exports.describeTypeReference = describeTypeReference;
/**
 * Determines whether an entity is deprecated.
 *
 * @param entity the entity to be checked.
 *
 * @returns true if the entity is marked as deprecated.
 */
function isDeprecated(entity) {
    return entity?.docs?.stability === Stability.Deprecated;
}
exports.isDeprecated = isDeprecated;
//# sourceMappingURL=assembly.js.map