/// <reference types="node" />
/// <reference types="node" />
import { Assembly } from './assembly';
/**
 * Returns true if the SPEC_FILE_NAME_COMPRESSED file exists in the directory.
 */
export declare function compressedAssemblyExists(directory: string): boolean;
/**
 * Finds the path to the SPEC_FILE_NAME file, which will either
 * be the assembly or hold instructions to find the assembly.
 *
 * @param directory path to a directory with an assembly file
 * @returns path to the SPEC_FILE_NAME file
 */
export declare function findAssemblyFile(directory: string): string;
/**
 * Replaces the file where the original assembly file *should* be found with a new assembly file.
 * Detects whether or not there is a compressed assembly, and if there is, compresses the new assembly also.
 * Replaces the fingerprint with '**********' rather than recalculating it, since we have modified the assembly.
 */
export declare function replaceAssembly(assembly: Assembly, directory: string): void;
/**
 * Writes the assembly file either as .jsii or .jsii.gz if zipped
 *
 * @param directory the directory path to place the assembly file
 * @param assembly the contents of the assembly
 * @param compress whether or not to zip the assembly (.jsii.gz)
 * @returns whether or not the assembly was zipped
 */
export declare function writeAssembly(directory: string, assembly: Assembly, { compress }?: {
    compress?: boolean;
}): boolean;
/**
 * Parses the assembly buffer and, if instructed to, redirects to the
 * compressed assembly buffer.
 *
 * @param assemblyBuffer buffer containing SPEC_FILE_NAME contents
 * @param readFile a callback to use for reading additional support files
 * @param validate whether or not to validate the assembly
 */
export declare function loadAssemblyFromBuffer(assemblyBuffer: Buffer, readFile?: (filename: string) => Buffer, validate?: boolean): Assembly;
/**
 * Loads the assembly file and, if present, follows instructions
 * found in the file to unzip compressed assemblies.
 *
 * @param directory the directory of the assembly file
 * @param validate whether to validate the contents of the file
 * @returns the assembly file as an Assembly object
 */
export declare function loadAssemblyFromPath(directory: string, validate?: boolean): Assembly;
/**
 * Loads the assembly file and, if present, follows instructions
 * found in the file to unzip compressed assemblies.
 *
 * @param pathToFile the path to the SPEC_FILE_NAME file
 * @param validate whether to validate the contents of the file
 * @returns the assembly file as an Assembly object
 */
export declare function loadAssemblyFromFile(pathToFile: string, validate?: boolean): Assembly;
//# sourceMappingURL=assembly-utils.d.ts.map