"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.usePagination = void 0;
const chalk_1 = __importDefault(require("chalk"));
const use_ref_mjs_1 = require('../use-ref.js');
const utils_mjs_1 = require('../utils.js');
const lines_mjs_1 = require('./lines.js');
const position_mjs_1 = require('./position.js');
function usePagination({ items, active, renderItem, pageSize, loop = true, }) {
    const state = (0, use_ref_mjs_1.useRef)({ position: 0, lastActive: 0 });
    const position = loop
        ? (0, position_mjs_1.infinite)({
            active,
            lastActive: state.current.lastActive,
            total: items.length,
            pageSize,
            pointer: state.current.position,
        })
        : (0, position_mjs_1.finite)({
            active,
            total: items.length,
            pageSize,
        });
    state.current.position = position;
    state.current.lastActive = active;
    const visibleLines = (0, lines_mjs_1.lines)({
        items,
        width: (0, utils_mjs_1.readlineWidth)(),
        renderItem,
        active,
        position,
        pageSize,
    }).join('\n');
    if (items.length > pageSize) {
        return `${visibleLines}\n${chalk_1.default.dim('(Use arrow keys to reveal more choices)')}`;
    }
    return visibleLines;
}
exports.usePagination = usePagination;
