"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Separator = void 0;
const core_1 = require("@inquirer/core");
Object.defineProperty(exports, "Separator", { enumerable: true, get: function () { return core_1.Separator; } });
const chalk_1 = __importDefault(require("chalk"));
const figures_1 = __importDefault(require("figures"));
const ansi_escapes_1 = __importDefault(require("ansi-escapes"));
function isSelectable(item) {
    return !core_1.Separator.isSeparator(item) && !item.disabled;
}
function renderItem({ item, isActive }) {
    if (core_1.Separator.isSeparator(item)) {
        return ` ${item.separator}`;
    }
    const line = item.name || item.value;
    if (item.disabled) {
        const disabledLabel = typeof item.disabled === 'string' ? item.disabled : '(disabled)';
        return chalk_1.default.dim(`- ${line} ${disabledLabel}`);
    }
    const color = isActive ? chalk_1.default.cyan : (x) => x;
    const prefix = isActive ? figures_1.default.pointer : ` `;
    return color(`${prefix} ${line}`);
}
exports.default = (0, core_1.createPrompt)((config, done) => {
    const { choices: items, loop = true, pageSize = 7 } = config;
    const firstRender = (0, core_1.useRef)(true);
    const prefix = (0, core_1.usePrefix)();
    const [status, setStatus] = (0, core_1.useState)('pending');
    const bounds = (0, core_1.useMemo)(() => {
        const first = items.findIndex(isSelectable);
        // TODO: Replace with `findLastIndex` when it's available.
        const last = items.length - 1 - [...items].reverse().findIndex(isSelectable);
        if (first < 0)
            throw new Error('[select prompt] No selectable choices. All choices are disabled.');
        return { first, last };
    }, [items]);
    const defaultItemIndex = (0, core_1.useMemo)(() => {
        if (!('default' in config))
            return -1;
        return items.findIndex((item) => isSelectable(item) && item.value === config.default);
    }, [config.default, items]);
    const [active, setActive] = (0, core_1.useState)(defaultItemIndex === -1 ? bounds.first : defaultItemIndex);
    // Safe to assume the cursor position always point to a Choice.
    const selectedChoice = items[active];
    (0, core_1.useKeypress)((key) => {
        if ((0, core_1.isEnterKey)(key)) {
            setStatus('done');
            done(selectedChoice.value);
        }
        else if ((0, core_1.isUpKey)(key) || (0, core_1.isDownKey)(key)) {
            if (loop ||
                ((0, core_1.isUpKey)(key) && active !== bounds.first) ||
                ((0, core_1.isDownKey)(key) && active !== bounds.last)) {
                const offset = (0, core_1.isUpKey)(key) ? -1 : 1;
                let next = active;
                do {
                    next = (next + offset + items.length) % items.length;
                } while (!isSelectable(items[next]));
                setActive(next);
            }
        }
        else if ((0, core_1.isNumberKey)(key)) {
            const position = Number(key.name) - 1;
            const item = items[position];
            if (item != null && isSelectable(item)) {
                setActive(position);
            }
        }
    });
    const message = chalk_1.default.bold(config.message);
    let helpTip;
    if (firstRender.current && items.length <= pageSize) {
        firstRender.current = false;
        helpTip = chalk_1.default.dim('(Use arrow keys)');
    }
    const page = (0, core_1.usePagination)({
        items,
        active,
        renderItem,
        pageSize,
        loop,
    });
    if (status === 'done') {
        return `${prefix} ${message} ${chalk_1.default.cyan(selectedChoice.name || selectedChoice.value)}`;
    }
    const choiceDescription = selectedChoice.description
        ? `\n${selectedChoice.description}`
        : ``;
    return `${[prefix, message, helpTip].filter(Boolean).join(' ')}\n${page}${choiceDescription}${ansi_escapes_1.default.cursorHide}`;
});
