import { createPrompt, useState, useKeypress, usePrefix, isEnterKey, } from '@inquirer/core';
import chalk from 'chalk';
import ansiEscapes from 'ansi-escapes';
export default createPrompt((config, done) => {
    const { validate = () => true } = config;
    const [status, setStatus] = useState('pending');
    const [errorMsg, setError] = useState(undefined);
    const [value, setValue] = useState('');
    const isLoading = status === 'loading';
    const prefix = usePrefix(isLoading);
    useKeypress(async (key, rl) => {
        // Ignore keypress while our prompt is doing other processing.
        if (status !== 'pending') {
            return;
        }
        if (isEnterKey(key)) {
            const answer = value;
            setStatus('loading');
            const isValid = await validate(answer);
            if (isValid === true) {
                setValue(answer);
                setStatus('done');
                done(answer);
            }
            else {
                // Reset the readline line value to the previous value. On line event, the value
                // get cleared, forcing the user to re-enter the value instead of fixing it.
                rl.write(value);
                setError(isValid || 'You must provide a valid value');
                setStatus('pending');
            }
        }
        else {
            setValue(rl.line);
            setError(undefined);
        }
    });
    const message = chalk.bold(config.message);
    let formattedValue = '';
    let helpTip;
    if (config.mask) {
        const maskChar = typeof config.mask === 'string' ? config.mask : '*';
        formattedValue = maskChar.repeat(value.length);
    }
    else if (status !== 'done') {
        helpTip = `${chalk.dim('[input is masked]')}${ansiEscapes.cursorHide}`;
    }
    if (status === 'done') {
        formattedValue = chalk.cyan(formattedValue);
    }
    let error = '';
    if (errorMsg) {
        error = chalk.red(`> ${errorMsg}`);
    }
    return [[prefix, message, formattedValue, helpTip].filter(Boolean).join(' '), error];
});
