"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@inquirer/core");
const chalk_1 = __importDefault(require("chalk"));
exports.default = (0, core_1.createPrompt)((config, done) => {
    const { validate = () => true } = config;
    const [status, setStatus] = (0, core_1.useState)('pending');
    const [defaultValue = '', setDefaultValue] = (0, core_1.useState)(config.default);
    const [errorMsg, setError] = (0, core_1.useState)(undefined);
    const [value, setValue] = (0, core_1.useState)('');
    const isLoading = status === 'loading';
    const prefix = (0, core_1.usePrefix)(isLoading);
    (0, core_1.useKeypress)((key, rl) => __awaiter(void 0, void 0, void 0, function* () {
        // Ignore keypress while our prompt is doing other processing.
        if (status !== 'pending') {
            return;
        }
        if ((0, core_1.isEnterKey)(key)) {
            const answer = value || defaultValue;
            setStatus('loading');
            const isValid = yield validate(answer);
            if (isValid === true) {
                setValue(answer);
                setStatus('done');
                done(answer);
            }
            else {
                // Reset the readline line value to the previous value. On line event, the value
                // get cleared, forcing the user to re-enter the value instead of fixing it.
                rl.write(value);
                setError(isValid || 'You must provide a valid value');
                setStatus('pending');
            }
        }
        else if ((0, core_1.isBackspaceKey)(key) && !value) {
            setDefaultValue(undefined);
        }
        else if (key.name === 'tab' && !value) {
            setDefaultValue(undefined);
            rl.clearLine(0); // Remove the tab character.
            rl.write(defaultValue);
            setValue(defaultValue);
        }
        else {
            setValue(rl.line);
            setError(undefined);
        }
    }));
    const message = chalk_1.default.bold(config.message);
    let formattedValue = value;
    if (typeof config.transformer === 'function') {
        formattedValue = config.transformer(value, { isFinal: status === 'done' });
    }
    else if (status === 'done') {
        formattedValue = chalk_1.default.cyan(value);
    }
    let defaultStr;
    if (defaultValue && status !== 'done' && !value) {
        defaultStr = chalk_1.default.dim(`(${defaultValue})`);
    }
    let error = '';
    if (errorMsg) {
        error = chalk_1.default.red(`> ${errorMsg}`);
    }
    return [[prefix, message, defaultStr, formattedValue].filter(Boolean).join(' '), error];
});
